/*
 * Decompiled with CFR 0.152.
 */
package dev.elifian.dimworldborder;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class DimensionalWBSavedData
extends class_18 {
    private DimensionalWorldborderSettings worldborderSettings;
    private final Map<String, Object> changedSettings = new HashMap<String, Object>();

    private DimensionalWBSavedData() {
        this.worldborderSettings = new DimensionalWorldborderSettings(class_2784.field_24122);
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 provider) {
        if (!this.changedSettings.isEmpty()) {
            DimensionalWBSavedData.writeChanged(tag, this.changedSettings);
            this.changedSettings.clear();
        }
        return tag;
    }

    public static DimensionalWBSavedData create() {
        return new DimensionalWBSavedData();
    }

    public static DimensionalWBSavedData load(class_2487 tag, class_7225.class_7874 provider) {
        DimensionalWBSavedData data = DimensionalWBSavedData.create();
        data.worldborderSettings = DimensionalWorldborderSettings.readFromTag(tag, class_2784.field_24122);
        return data;
    }

    public static DimensionalWBSavedData get(class_3218 level) {
        return (DimensionalWBSavedData)level.method_17983().method_17924(new class_18.class_8645(DimensionalWBSavedData::create, DimensionalWBSavedData::load, null), "dimworldborder");
    }

    public void applyTo(class_2784 border) {
        this.worldborderSettings.applyTo(border);
    }

    public void setWorldborderSettings(class_2784.class_5200 settings) {
        DimensionalWorldborderSettings newSettings = new DimensionalWorldborderSettings(settings);
        this.updateChangedSettings(newSettings);
        if (!this.changedSettings.isEmpty()) {
            this.worldborderSettings = newSettings;
            this.method_80();
        }
    }

    private void updateChangedSettings(DimensionalWorldborderSettings newSettings) {
        this.changedSettings.clear();
        if (newSettings.getCenterX() != this.worldborderSettings.getCenterX()) {
            this.changedSettings.put("BorderCenterX", newSettings.getCenterX());
        }
        if (newSettings.getCenterZ() != this.worldborderSettings.getCenterZ()) {
            this.changedSettings.put("BorderCenterZ", newSettings.getCenterZ());
        }
        if (newSettings.getDamagePerBlock() != this.worldborderSettings.getDamagePerBlock()) {
            this.changedSettings.put("BorderDamagePerBlock", newSettings.getDamagePerBlock());
        }
        if (newSettings.getSafeZone() != this.worldborderSettings.getSafeZone()) {
            this.changedSettings.put("BorderSafeZone", newSettings.getSafeZone());
        }
        if (newSettings.getWarningBlocks() != this.worldborderSettings.getWarningBlocks()) {
            this.changedSettings.put("BorderWarningBlocks", newSettings.getWarningBlocks());
        }
        if (newSettings.getWarningTime() != this.worldborderSettings.getWarningTime()) {
            this.changedSettings.put("BorderWarningTime", newSettings.getWarningTime());
        }
        if (newSettings.getSize() != this.worldborderSettings.getSize()) {
            this.changedSettings.put("BorderSize", newSettings.getSize());
        }
        if (newSettings.getSizeLerpTime() != this.worldborderSettings.getSizeLerpTime()) {
            this.changedSettings.put("BorderSizeLerpTime", newSettings.getSizeLerpTime());
        }
        if (newSettings.getSizeLerpTarget() != this.worldborderSettings.getSizeLerpTarget()) {
            this.changedSettings.put("BorderSizeLerpTarget", newSettings.getSizeLerpTarget());
        }
    }

    private static void writeChanged(class_2487 tag, Map<String, Object> changedSettings) {
        for (Map.Entry<String, Object> entry : changedSettings.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            switch (key) {
                case "BorderCenterX": 
                case "BorderCenterZ": 
                case "BorderSize": 
                case "BorderSizeLerpTarget": 
                case "BorderSafeZone": 
                case "BorderDamagePerBlock": {
                    tag.method_10549(key, ((Double)value).doubleValue());
                    break;
                }
                case "BorderSizeLerpTime": {
                    tag.method_10544(key, ((Long)value).longValue());
                    break;
                }
                case "BorderWarningBlocks": 
                case "BorderWarningTime": {
                    tag.method_10569(key, ((Integer)value).intValue());
                }
            }
        }
    }

    public static class DimensionalWorldborderSettings {
        private final double centerX;
        private final double centerZ;
        private final double damagePerBlock;
        private final double safeZone;
        private final int warningBlocks;
        private final int warningTime;
        private final double size;
        private final long sizeLerpTime;
        private final double sizeLerpTarget;

        DimensionalWorldborderSettings(double centerX, double centerZ, double damagePerBlock, double safeZone, int warningBlocks, int warningTime, double size, long sizeLerpTime, double sizeLerpTarget) {
            this.centerX = centerX;
            this.centerZ = centerZ;
            this.damagePerBlock = damagePerBlock;
            this.safeZone = safeZone;
            this.warningBlocks = warningBlocks;
            this.warningTime = warningTime;
            this.size = size;
            this.sizeLerpTime = sizeLerpTime;
            this.sizeLerpTarget = sizeLerpTarget;
        }

        DimensionalWorldborderSettings(class_2784.class_5200 settings) {
            this.centerX = settings.method_27356();
            this.centerZ = settings.method_27359();
            this.damagePerBlock = settings.method_27360();
            this.safeZone = settings.method_27361();
            this.warningBlocks = settings.method_27362();
            this.warningTime = settings.method_27363();
            this.size = settings.method_27364();
            this.sizeLerpTime = settings.method_27365();
            this.sizeLerpTarget = settings.method_27366();
        }

        public double getCenterX() {
            return this.centerX;
        }

        public double getCenterZ() {
            return this.centerZ;
        }

        public double getDamagePerBlock() {
            return this.damagePerBlock;
        }

        public double getSafeZone() {
            return this.safeZone;
        }

        public int getWarningBlocks() {
            return this.warningBlocks;
        }

        public int getWarningTime() {
            return this.warningTime;
        }

        public double getSize() {
            return this.size;
        }

        public long getSizeLerpTime() {
            return this.sizeLerpTime;
        }

        public double getSizeLerpTarget() {
            return this.sizeLerpTarget;
        }

        private static <T> T getNumericTagValue(class_2487 tag, String key, T fallback, Function<class_2514, T> valueExtractor) {
            if (!tag.method_10573(key, 99)) {
                return fallback;
            }
            class_2520 value = tag.method_10580(key);
            if (value == null) {
                return fallback;
            }
            try {
                return valueExtractor.apply((class_2514)value);
            }
            catch (ClassCastException e) {
                return fallback;
            }
        }

        public static DimensionalWorldborderSettings readFromTag(class_2487 tag, class_2784.class_5200 defaultSettings) {
            double centerX = class_3532.method_15350((double)DimensionalWorldborderSettings.getNumericTagValue(tag, "BorderCenterX", defaultSettings.method_27356(), class_2514::method_10697), (double)-2.9999984E7, (double)2.9999984E7);
            double centerZ = class_3532.method_15350((double)DimensionalWorldborderSettings.getNumericTagValue(tag, "BorderCenterZ", defaultSettings.method_27359(), class_2514::method_10697), (double)-2.9999984E7, (double)2.9999984E7);
            double size = DimensionalWorldborderSettings.getNumericTagValue(tag, "BorderSize", defaultSettings.method_27364(), class_2514::method_10697);
            long lerpTime = DimensionalWorldborderSettings.getNumericTagValue(tag, "BorderSizeLerpTime", defaultSettings.method_27365(), class_2514::method_10699);
            double lerpTarget = DimensionalWorldborderSettings.getNumericTagValue(tag, "BorderSizeLerpTarget", defaultSettings.method_27366(), class_2514::method_10697);
            double safeZone = DimensionalWorldborderSettings.getNumericTagValue(tag, "BorderSafeZone", defaultSettings.method_27361(), class_2514::method_10697);
            double damagePerBlock = DimensionalWorldborderSettings.getNumericTagValue(tag, "BorderDamagePerBlock", defaultSettings.method_27360(), class_2514::method_10697);
            int warningBlocks = DimensionalWorldborderSettings.getNumericTagValue(tag, "BorderWarningBlocks", defaultSettings.method_27362(), class_2514::method_10701);
            int warningTime = DimensionalWorldborderSettings.getNumericTagValue(tag, "BorderWarningTime", defaultSettings.method_27363(), class_2514::method_10701);
            return new DimensionalWorldborderSettings(centerX, centerZ, damagePerBlock, safeZone, warningBlocks, warningTime, size, lerpTime, lerpTarget);
        }

        public void applyTo(class_2784 border) {
            border.method_11978(this.getCenterX(), this.getCenterZ());
            border.method_11955(this.getDamagePerBlock());
            border.method_11981(this.getSafeZone());
            border.method_11967(this.getWarningBlocks());
            border.method_11975(this.getWarningTime());
            if (this.getSizeLerpTime() > 0L) {
                border.method_11957(this.getSize(), this.getSizeLerpTarget(), this.getSizeLerpTime());
            } else {
                border.method_11969(this.getSize());
            }
        }
    }
}

