/*
 * Decompiled with CFR 0.152.
 */
package dev.elifian.dimworldborder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.elifian.dimworldborder.DimensionalWBSavedData;
import dev.elifian.dimworldborder.DimensionalWorldBorder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2274;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class DimensionalWBCommand {
    private static final Map<String, Map<String, String>> LOCALIZATION_STRINGS = new HashMap<String, Map<String, String>>();
    private static boolean isLoaded = false;
    protected static final String DEFAULT_LANGUAGE = "en_us";
    private static final DynamicCommandExceptionType ERROR_SAME_SIZE = DimensionalWBCommand.createException(".set.failed.nochange", false);
    private static final DynamicCommandExceptionType ERROR_TOO_SMALL = DimensionalWBCommand.createException(".set.failed.small", false);
    private static final DynamicCommandExceptionType ERROR_TOO_BIG = DimensionalWBCommand.createException(".set.failed.big", true);
    private static final DynamicCommandExceptionType ERROR_SAME_CENTER = DimensionalWBCommand.createException(".center.failed", false);
    private static final DynamicCommandExceptionType ERROR_TOO_FAR_OUT = DimensionalWBCommand.createException(".set.failed.far", true);
    private static final DynamicCommandExceptionType ERROR_SAME_DAMAGE_BUFFER = DimensionalWBCommand.createException(".damage.buffer.failed", false);
    private static final DynamicCommandExceptionType ERROR_SAME_DAMAGE_AMOUNT = DimensionalWBCommand.createException(".damage.amount.failed", false);
    private static final DynamicCommandExceptionType ERROR_SAME_WARNING_DISTANCE = DimensionalWBCommand.createException(".warning.distance.failed", false);
    private static final DynamicCommandExceptionType ERROR_SAME_WARNING_TIME = DimensionalWBCommand.createException(".warning.time.failed", false);

    private static DynamicCommandExceptionType createException(String key, boolean hasExtraArgs) {
        return new DynamicCommandExceptionType(obj -> {
            String[] args = (String[])obj;
            String language = args[0];
            String dimension = args[1];
            if (hasExtraArgs) {
                return class_2561.method_43470((String)DimensionalWBCommand.getLocalizedString(language, "commands.dimworldborder" + key, dimension, args[2]));
            }
            return class_2561.method_43470((String)DimensionalWBCommand.getLocalizedString(language, "commands.dimworldborder" + key, dimension));
        });
    }

    public static void loadLocalization() {
        LOCALIZATION_STRINGS.clear();
        isLoaded = false;
        Path modResourceDir = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("dimworldborder").orElseThrow(() -> new IllegalStateException("Mod dimworldborder not found"))).findPath("assets/dimworldborder/lang").orElseThrow(() -> new IllegalStateException("Language directory not found for mod dimworldborder"));
        try (Stream<Path> paths = Files.list(modResourceDir);){
            paths.filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                String fileName = path.getFileName().toString();
                String lang = fileName.replace(".json", "");
                class_2960 loc = class_2960.method_60655((String)"dimworldborder", (String)("lang/" + fileName));
                try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                     InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    HashMap<String, String> translations = new HashMap<String, String>();
                    for (Map.Entry entryJson : json.entrySet()) {
                        if (!((JsonElement)entryJson.getValue()).isJsonPrimitive() || !((JsonElement)entryJson.getValue()).getAsJsonPrimitive().isString()) continue;
                        translations.put((String)entryJson.getKey(), ((JsonElement)entryJson.getValue()).getAsString());
                    }
                    LOCALIZATION_STRINGS.put(lang, translations);
                    DimensionalWorldBorder.LOGGER.info("Loaded localization for {} from {}", (Object)lang, (Object)loc);
                }
                catch (IOException e) {
                    DimensionalWorldBorder.LOGGER.error("Failed to load localization file {}: {}", (Object)loc, (Object)e.getMessage());
                }
            });
        }
        catch (IOException e) {
            DimensionalWorldBorder.LOGGER.error("Failed to list localization files: {}", (Object)e.getMessage());
        }
        isLoaded = !LOCALIZATION_STRINGS.isEmpty();
    }

    public static String getLocalizedString(String language, String key, Object ... args) {
        if (!isLoaded) {
            return key;
        }
        Map<String, String> translations = LOCALIZATION_STRINGS.getOrDefault(language, LOCALIZATION_STRINGS.get(DEFAULT_LANGUAGE));
        if (translations == null) {
            return key;
        }
        String format = translations.getOrDefault(key, key);
        return String.format(format, args);
    }

    private static String getTranslatedDimensionName(class_2168 source, class_3218 dimension) {
        class_3222 player = source.method_44023();
        String language = player != null ? player.method_53823().comp_1951() : DEFAULT_LANGUAGE;
        String dimensionName = dimension.method_27983().method_29177().toString();
        return DimensionalWBCommand.getLocalizedString(language, dimensionName, dimensionName);
    }

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dimworldborder").requires(source -> source.method_9259(2))).then(DimensionalWBCommand.buildCommandStructure()));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dwb").requires(source -> source.method_9259(2))).then(DimensionalWBCommand.buildCommandStructure()));
    }

    private static ArgumentBuilder<class_2168, ?> buildCommandStructure() {
        return ((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9247((String)"add").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(context -> DimensionalWBCommand.setSize((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"), ((class_2168)context.getSource()).method_9225().method_8621().method_11965() + DoubleArgumentType.getDouble((CommandContext)context, (String)"distance"), 0L))).then(class_2170.method_9244((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> DimensionalWBCommand.setSize((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"), ((class_2168)context.getSource()).method_9225().method_8621().method_11965() + DoubleArgumentType.getDouble((CommandContext)context, (String)"distance"), ((class_2168)context.getSource()).method_9225().method_8621().method_11962() + (long)IntegerArgumentType.getInteger((CommandContext)context, (String)"time") * 1000L)))))).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(context -> DimensionalWBCommand.setSize((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"), DoubleArgumentType.getDouble((CommandContext)context, (String)"distance"), 0L))).then(class_2170.method_9244((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> DimensionalWBCommand.setSize((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"), DoubleArgumentType.getDouble((CommandContext)context, (String)"distance"), (long)IntegerArgumentType.getInteger((CommandContext)context, (String)"time") * 1000L)))))).then(class_2170.method_9247((String)"center").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2274.method_9723()).executes(context -> DimensionalWBCommand.setCenter((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"), class_2274.method_9724((CommandContext)context, (String)"pos")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"damage").then(class_2170.method_9247((String)"amount").then(class_2170.method_9244((String)"damagePerBlock", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> DimensionalWBCommand.setDamageAmount((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"), FloatArgumentType.getFloat((CommandContext)context, (String)"damagePerBlock")))))).then(class_2170.method_9247((String)"buffer").then(class_2170.method_9244((String)"distance", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> DimensionalWBCommand.setDamageBuffer((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"), FloatArgumentType.getFloat((CommandContext)context, (String)"distance"))))))).then(class_2170.method_9247((String)"get").executes(context -> DimensionalWBCommand.getSize((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"warning").then(class_2170.method_9247((String)"distance").then(class_2170.method_9244((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> DimensionalWBCommand.setWarningDistance((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"), IntegerArgumentType.getInteger((CommandContext)context, (String)"distance")))))).then(class_2170.method_9247((String)"time").then(class_2170.method_9244((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> DimensionalWBCommand.setWarningTime((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"))))));
    }

    private static int setDamageBuffer(class_2168 source, class_3218 dimension, float damageBuffer) throws CommandSyntaxException {
        class_2784 worldborder = dimension.method_8621();
        class_3222 player = source.method_44023();
        String language = player != null ? player.method_53823().comp_1951() : DEFAULT_LANGUAGE;
        String translatedDimensionName = DimensionalWBCommand.getTranslatedDimensionName(source, dimension);
        if (worldborder.method_11971() == (double)damageBuffer) {
            throw ERROR_SAME_DAMAGE_BUFFER.create((Object)new String[]{language, translatedDimensionName});
        }
        worldborder.method_11981((double)damageBuffer);
        DimensionalWBSavedData.get(dimension).setWorldborderSettings(worldborder.method_27355());
        source.method_9226(() -> class_2561.method_43470((String)DimensionalWBCommand.getLocalizedString(language, "commands.dimworldborder.damage.buffer.success", translatedDimensionName, Float.valueOf(damageBuffer))), true);
        return (int)damageBuffer;
    }

    private static int setDamageAmount(class_2168 source, class_3218 dimension, float damagePerBlock) throws CommandSyntaxException {
        class_2784 worldborder = dimension.method_8621();
        class_3222 player = source.method_44023();
        String language = player != null ? player.method_53823().comp_1951() : DEFAULT_LANGUAGE;
        String translatedDimensionName = DimensionalWBCommand.getTranslatedDimensionName(source, dimension);
        if (worldborder.method_11953() == (double)damagePerBlock) {
            throw ERROR_SAME_DAMAGE_AMOUNT.create((Object)new String[]{language, translatedDimensionName});
        }
        worldborder.method_11955((double)damagePerBlock);
        DimensionalWBSavedData.get(dimension).setWorldborderSettings(worldborder.method_27355());
        source.method_9226(() -> class_2561.method_43470((String)DimensionalWBCommand.getLocalizedString(language, "commands.dimworldborder.damage.amount.success", translatedDimensionName, Float.valueOf(damagePerBlock))), true);
        return (int)damagePerBlock;
    }

    private static int setWarningTime(class_2168 source, class_3218 dimension, int warningTime) throws CommandSyntaxException {
        class_2784 worldborder = dimension.method_8621();
        class_3222 player = source.method_44023();
        String language = player != null ? player.method_53823().comp_1951() : DEFAULT_LANGUAGE;
        String translatedDimensionName = DimensionalWBCommand.getTranslatedDimensionName(source, dimension);
        if (worldborder.method_11956() == warningTime) {
            throw ERROR_SAME_WARNING_TIME.create((Object)new String[]{language, translatedDimensionName});
        }
        worldborder.method_11975(warningTime);
        DimensionalWBSavedData.get(dimension).setWorldborderSettings(worldborder.method_27355());
        source.method_9226(() -> class_2561.method_43470((String)DimensionalWBCommand.getLocalizedString(language, "commands.dimworldborder.warning.time.success", translatedDimensionName, warningTime)), true);
        return warningTime;
    }

    private static int setWarningDistance(class_2168 source, class_3218 dimension, int warningDistance) throws CommandSyntaxException {
        class_2784 worldborder = dimension.method_8621();
        class_3222 player = source.method_44023();
        String language = player != null ? player.method_53823().comp_1951() : DEFAULT_LANGUAGE;
        String translatedDimensionName = DimensionalWBCommand.getTranslatedDimensionName(source, dimension);
        if (worldborder.method_11972() == warningDistance) {
            throw ERROR_SAME_WARNING_DISTANCE.create((Object)new String[]{language, translatedDimensionName});
        }
        worldborder.method_11967(warningDistance);
        DimensionalWBSavedData.get(dimension).setWorldborderSettings(worldborder.method_27355());
        source.method_9226(() -> class_2561.method_43470((String)DimensionalWBCommand.getLocalizedString(language, "commands.dimworldborder.warning.distance.success", translatedDimensionName, warningDistance)), true);
        return warningDistance;
    }

    private static int getSize(class_2168 source, class_3218 dimension) {
        double size = dimension.method_8621().method_11965();
        class_3222 player = source.method_44023();
        String language = player != null ? player.method_53823().comp_1951() : DEFAULT_LANGUAGE;
        String translatedDimensionName = DimensionalWBCommand.getTranslatedDimensionName(source, dimension);
        source.method_9226(() -> class_2561.method_43470((String)DimensionalWBCommand.getLocalizedString(language, "commands.dimworldborder.get", translatedDimensionName, class_3532.method_15357((double)(size + 0.5)))), false);
        return class_3532.method_15357((double)(size + 0.5));
    }

    private static int setCenter(class_2168 source, class_3218 dimension, class_241 vec2) throws CommandSyntaxException {
        class_2784 worldborder = dimension.method_8621();
        class_3222 player = source.method_44023();
        String language = player != null ? player.method_53823().comp_1951() : DEFAULT_LANGUAGE;
        String translatedDimensionName = DimensionalWBCommand.getTranslatedDimensionName(source, dimension);
        if (worldborder.method_11964() == (double)vec2.field_1343 && worldborder.method_11980() == (double)vec2.field_1342) {
            throw ERROR_SAME_CENTER.create((Object)new String[]{language, translatedDimensionName});
        }
        if ((double)Math.abs(vec2.field_1343) > 2.9999984E7 || (double)Math.abs(vec2.field_1342) > 2.9999984E7) {
            throw ERROR_TOO_FAR_OUT.create((Object)new String[]{language, translatedDimensionName});
        }
        worldborder.method_11978((double)vec2.field_1343, (double)vec2.field_1342);
        DimensionalWBSavedData.get(dimension).setWorldborderSettings(worldborder.method_27355());
        source.method_9226(() -> class_2561.method_43470((String)DimensionalWBCommand.getLocalizedString(language, "commands.dimworldborder.center.success", translatedDimensionName, Float.valueOf(vec2.field_1343), Float.valueOf(vec2.field_1342))), true);
        return 0;
    }

    private static int setSize(class_2168 source, class_3218 dimension, double newSize, long lerpTime) throws CommandSyntaxException {
        class_2784 worldborder = dimension.method_8621();
        class_3222 player = source.method_44023();
        String language = player != null ? player.method_53823().comp_1951() : DEFAULT_LANGUAGE;
        String translatedDimensionName = DimensionalWBCommand.getTranslatedDimensionName(source, dimension);
        double currentSize = worldborder.method_11965();
        if (currentSize == newSize) {
            throw ERROR_SAME_SIZE.create((Object)new String[]{language, translatedDimensionName});
        }
        if (newSize < 1.0) {
            throw ERROR_TOO_SMALL.create((Object)new String[]{language, translatedDimensionName});
        }
        if (newSize > 5.9999968E7) {
            throw ERROR_TOO_BIG.create((Object)new String[]{language, translatedDimensionName});
        }
        if (lerpTime > 0L) {
            worldborder.method_11957(currentSize, newSize, lerpTime);
            DimensionalWBSavedData.get(dimension).setWorldborderSettings(worldborder.method_27355());
            String key = newSize > currentSize ? "commands.dimworldborder.set.grow" : "commands.dimworldborder.set.shrink";
            source.method_9226(() -> class_2561.method_43470((String)DimensionalWBCommand.getLocalizedString(language, key, translatedDimensionName, newSize, (double)lerpTime / 1000.0)), true);
        } else {
            worldborder.method_11969(newSize);
            DimensionalWBSavedData.get(dimension).setWorldborderSettings(worldborder.method_27355());
            source.method_9226(() -> class_2561.method_43470((String)DimensionalWBCommand.getLocalizedString(language, "commands.dimworldborder.set.immediate", translatedDimensionName, newSize)), true);
        }
        return (int)(newSize - currentSize);
    }
}

