/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.fabric.core.config;

import blue.endless.jankson.Comment;
import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.api.DeserializationException;
import blue.endless.jankson.api.SyntaxError;
import com.kekecreations.arts_and_crafts.ArtsAndCrafts;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class FabricConfig
implements class_8710 {
    public static final class_8710.class_9154<FabricConfig> PACKET_ID = new class_8710.class_9154(ArtsAndCrafts.id("sync_config"));
    public static final class_9139<class_2540, FabricConfig> PACKET_CODEC = class_9139.method_56438(FabricConfig::writeToClient, FabricConfig::readFromServer);
    private static final Jankson JANKSON = Jankson.builder().registerSerializer(class_2960.class, (id, marshaller) -> marshaller.serialize((Object)id.toString())).registerDeserializer(String.class, class_2960.class, (str, marshaller) -> class_2960.method_12829((String)str)).build();
    public static class_2561 lastError;
    @Comment(value="Allows flower pots to be dyed when true. Default value: true")
    private boolean enableDyedFlowerPots = true;
    @Comment(value="Should chalk sticks be enabled? Default value: true")
    private boolean enableChalkSticks = true;
    @Comment(value="Allows decorated pots to be dyed when true. Default value: true")
    private boolean enableDyedDecoratedPots = true;
    @Comment(value="When true adds a new creative mode tab full of Arts & Crafts features!")
    private boolean enableCreativeModeTab = true;
    @Comment(value="Allows the player to bleach sheep  (Yirmiri wanted this really bad for some reason)")
    private boolean bleachableSheep = false;
    @Comment(value="2025 April fools features")
    private boolean aprilFools2025 = false;

    private static File getConfigFile() {
        return Path.of(FabricLoader.getInstance().getConfigDir().toString(), "arts_and_crafts", "config.json5").toFile();
    }

    public void save() throws FileNotFoundException {
        FabricConfig.getConfigFile().getParentFile().mkdirs();
        try (FileOutputStream outStream = new FileOutputStream(FabricConfig.getConfigFile());){
            outStream.write(JANKSON.toJson((Object)this).toJson(true, true).getBytes());
        }
        catch (IOException e) {
            ArtsAndCrafts.LOG.error("IO exception while saving config: {}", (Object)e.getMessage());
        }
    }

    public static FabricConfig load() {
        FabricConfig defaults = new FabricConfig();
        try {
            if (FabricConfig.getConfigFile().exists()) {
                lastError = null;
                JsonObject json = JANKSON.load(FabricConfig.getConfigFile());
                return (FabricConfig)JANKSON.fromJsonCarefully(json, FabricConfig.class);
            }
            defaults.save();
            lastError = null;
            return defaults;
        }
        catch (SyntaxError e) {
            ArtsAndCrafts.LOG.error("Config syntax error. {}.", (Object)e.getLineMessage());
            ArtsAndCrafts.LOG.error(e.getMessage());
            ArtsAndCrafts.LOG.warn("Using default configuration.");
            lastError = class_2561.method_43471((String)"message.arts_and_crafts.error.config.general");
        }
        catch (DeserializationException e) {
            ArtsAndCrafts.LOG.error("MCDE's config deserialization error.");
            ArtsAndCrafts.LOG.error("{}", (Object)e.getMessage());
            if (e.getCause() != null) {
                ArtsAndCrafts.LOG.error("Cause: {}", (Object)e.getCause().getMessage());
            }
            ArtsAndCrafts.LOG.warn("Using default configuration.");
            lastError = class_2561.method_43471((String)"message.arts_and_crafts.error.config.general");
        }
        catch (IOException e) {
            ArtsAndCrafts.LOG.error("IO exception occured while reading config. Using defaults.");
            ArtsAndCrafts.LOG.error(e.getMessage());
            ArtsAndCrafts.LOG.warn("Using default configuration.");
            lastError = class_2561.method_43471((String)"message.arts_and_crafts.error.config.general");
        }
        return defaults;
    }

    public static FabricConfig readFromServer(class_2540 buf) {
        try {
            return (FabricConfig)JANKSON.fromJsonCarefully(buf.method_19772(), FabricConfig.class);
        }
        catch (DeserializationException | SyntaxError e) {
            ArtsAndCrafts.LOG.error("Error while retrieving config from server: {}", e);
            return null;
        }
    }

    public void writeToClient(class_2540 buf) {
        buf.method_10814(JANKSON.toJson((Object)this).toJson());
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }

    public boolean areDyedFlowerPotsEnabled() {
        return this.enableDyedFlowerPots;
    }

    public boolean areChalkSticksEnabled() {
        return this.enableChalkSticks;
    }

    public boolean areDyedDecoratedPotsEnabled() {
        return this.enableDyedDecoratedPots;
    }

    public boolean enableCreativeModeTab() {
        return this.enableCreativeModeTab;
    }

    public boolean bleachableSheep() {
        return this.bleachableSheep;
    }

    public boolean aprilFools2025() {
        return this.aprilFools2025;
    }

    public static enum ListType {
        ALLOW,
        DENY;

    }
}

