/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.entity;

import com.kekecreations.arts_and_crafts.common.block.Floatable;
import com.kekecreations.arts_and_crafts.common.block.FloatingBlock;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.kekecreations.arts_and_crafts.core.registry.ACEntityTypes;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3231;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FloatingBlockEntity
extends class_1297 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private class_2680 blockState = ACBlocks.CORK.get().method_9564();
    public int time;
    public boolean dropItem = true;
    private boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    @Nullable
    public class_2487 blockData;
    protected static final class_2940<class_2338> DATA_START_POS = class_2945.method_12791(FloatingBlockEntity.class, (class_2941)class_2943.field_13324);

    public FloatingBlockEntity(class_1299<? extends FloatingBlockEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    private FloatingBlockEntity(class_1937 level, double d, double e, double f, class_2680 blockState) {
        this(ACEntityTypes.FLOATING_BLOCK.get(), level);
        this.blockState = blockState;
        this.field_23807 = true;
        this.method_5814(d, e, f);
        this.method_18799(class_243.field_1353);
        this.field_6014 = d;
        this.field_6036 = e;
        this.field_5969 = f;
        this.setStartPos(this.method_24515());
    }

    public static FloatingBlockEntity floating(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        FloatingBlockEntity floatingBlockEntity = new FloatingBlockEntity(level, (double)blockPos.method_10263() + 0.5, blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, blockState.method_28498((class_2769)class_2741.field_12508) ? (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)) : blockState);
        level.method_8652(blockPos, blockState.method_26227().method_15759(), 3);
        level.method_8649((class_1297)floatingBlockEntity);
        return floatingBlockEntity;
    }

    public static boolean canCollide(class_1297 entity) {
        return entity.method_30948() || entity.method_5810();
    }

    public boolean method_30949(class_1297 entity) {
        return FloatingBlockEntity.canCollide(entity);
    }

    public boolean method_30948() {
        return true;
    }

    private void moveCollidedEntities(List<class_1297> pEntities) {
        for (class_1297 entity : pEntities) {
            entity.method_5784(class_1313.field_6310, this.method_18798().method_1031(0.0, 0.3, 0.0));
        }
    }

    private void moveCollidedEntitiesToTheSurface(List<class_1297> pEntities) {
        for (class_1297 entity : pEntities) {
            entity.method_5784(class_1313.field_6310, this.method_18798().method_1031(0.0, 1.0, 0.0));
        }
    }

    public boolean method_5732() {
        return false;
    }

    public void setStartPos(class_2338 blockPos) {
        this.field_6011.method_12778(DATA_START_POS, (Object)blockPos);
    }

    public class_2338 getStartPos() {
        return (class_2338)this.field_6011.method_12789(DATA_START_POS);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_START_POS, (Object)class_2338.field_10980);
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public void method_5773() {
        if (this.blockState.method_26215()) {
            this.method_31472();
            return;
        }
        class_2248 block = this.blockState.method_26204();
        this.method_5784(class_1313.field_6308, this.method_18798());
        class_2338 blockPos = this.method_24515();
        ++this.time;
        if (!this.method_37908().field_9236) {
            if (FloatingBlock.isInWater(this.method_37908().method_8320(blockPos.method_10084())) && this.method_18798().method_10214() < 0.2) {
                this.method_18799(this.method_18798().method_1031(0.0, 0.1, 0.0));
                this.moveCollidedEntities(this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(0.1), class_1301.field_6156));
            }
            if (FloatingBlock.isNotInWater(this.method_37908().method_8320(blockPos.method_10084()))) {
                this.moveCollidedEntitiesToTheSurface(this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(0.1), class_1301.field_6156));
                this.method_18800(0.0, 0.0, 0.0);
                this.method_37908().method_8652(blockPos, this.blockState, 3);
                this.method_31472();
            }
        }
    }

    public boolean method_5747(float f, float g, class_1282 damageSource) {
        class_1282 damageSource2;
        if (!this.hurtEntities) {
            return false;
        }
        int i = class_3532.method_15386((float)(f - 1.0f));
        if (i < 0) {
            return false;
        }
        Predicate predicate = class_1301.field_6156.and(class_1301.field_6157);
        class_2248 block = this.blockState.method_26204();
        if (block instanceof Floatable) {
            Floatable floatable = (Floatable)block;
            damageSource2 = floatable.getFallDamageSource(this);
        } else {
            damageSource2 = this.method_48923().method_48798((class_1297)this);
        }
        class_1282 damageSource22 = damageSource2;
        float h = Math.min(class_3532.method_15375((float)((float)i * this.fallDamagePerDistance)), this.fallDamageMax);
        this.method_37908().method_8333((class_1297)this, this.method_5829(), predicate).forEach(entity -> entity.method_5643(damageSource22, h));
        boolean bl = this.blockState.method_26164(class_3481.field_15486);
        if (bl && h > 0.0f && this.field_5974.method_43057() < 0.05f + (float)i * 0.05f) {
            class_2680 blockState = class_2199.method_9346((class_2680)this.blockState);
            if (blockState == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = blockState;
            }
        }
        return false;
    }

    protected void method_5652(class_2487 compoundTag) {
        compoundTag.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.blockState));
        compoundTag.method_10569("Time", this.time);
        compoundTag.method_10556("DropItem", this.dropItem);
        compoundTag.method_10556("HurtEntities", this.hurtEntities);
        compoundTag.method_10548("FallHurtAmount", this.fallDamagePerDistance);
        compoundTag.method_10569("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            compoundTag.method_10566("TileEntityData", (class_2520)this.blockData);
        }
        compoundTag.method_10556("CancelDrop", this.cancelDrop);
    }

    protected void method_5749(class_2487 compoundTag) {
        this.blockState = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)compoundTag.method_10562("BlockState"));
        this.time = compoundTag.method_10550("Time");
        if (compoundTag.method_10573("HurtEntities", 99)) {
            this.hurtEntities = compoundTag.method_10577("HurtEntities");
            this.fallDamagePerDistance = compoundTag.method_10583("FallHurtAmount");
            this.fallDamageMax = compoundTag.method_10550("FallHurtMax");
        } else if (this.blockState.method_26164(class_3481.field_15486)) {
            this.hurtEntities = true;
        }
        if (compoundTag.method_10573("DropItem", 99)) {
            this.dropItem = compoundTag.method_10577("DropItem");
        }
        if (compoundTag.method_10573("TileEntityData", 10)) {
            this.blockData = compoundTag.method_10562("TileEntityData");
        }
        this.cancelDrop = compoundTag.method_10577("CancelDrop");
        if (this.blockState.method_26215()) {
            this.blockState = class_2246.field_10102.method_9564();
        }
    }

    public void setHurtsEntities(float f, int i) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = f;
        this.fallDamageMax = i;
    }

    public void disableDrop() {
        this.cancelDrop = true;
    }

    public boolean method_5862() {
        return false;
    }

    public void method_5819(class_129 crashReportCategory) {
        super.method_5819(crashReportCategory);
        crashReportCategory.method_578("Immitating BlockState", (Object)this.blockState.toString());
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    protected class_2561 method_23315() {
        return class_2561.method_43469((String)"entity.minecraft.falling_block_type", (Object[])new Object[]{this.blockState.method_26204().method_9518()});
    }

    public boolean method_5833() {
        return true;
    }

    public class_2596<class_2602> method_18002(class_3231 serverEntity) {
        return new class_2604((class_1297)this, serverEntity, class_2248.method_9507((class_2680)this.getBlockState()));
    }

    public void method_31471(class_2604 clientboundAddEntityPacket) {
        super.method_31471(clientboundAddEntityPacket);
        this.blockState = class_2248.method_9531((int)clientboundAddEntityPacket.method_11166());
        this.field_23807 = true;
        double d = clientboundAddEntityPacket.method_11175();
        double e = clientboundAddEntityPacket.method_11174();
        double f = clientboundAddEntityPacket.method_11176();
        this.method_5814(d, e, f);
        this.setStartPos(this.method_24515());
    }
}

