/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.mightymail.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.mightymail.block.MailboxBlock;
import com.mrcrayfish.mightymail.core.ModBlocks;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class MigrateCommand {
    private static final WeakHashMap<UUID, Long> PENDING = new WeakHashMap();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mighty_mail:migrate").requires(source -> source.method_9259(2) && source.method_43737())).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player != null) {
                PENDING.put(player.method_5667(), class_156.method_658());
                class_5250 link = class_2561.method_43470((String)"CONFIRM");
                link.method_10862(link.method_10866().method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1075).method_10958(new class_2558(class_2558.class_2559.field_11750, "/mighty_mail:confirm")));
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"This is an irreversible action. Click ").method_10852((class_2561)link).method_27693(" to start action."), false);
                return 1;
            }
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mighty_mail:confirm").requires(source -> source.method_9259(2) && source.method_43737())).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player != null && PENDING.containsKey(player.method_5667())) {
                if (class_156.method_658() - PENDING.get(player.method_5667()) >= 10000L) {
                    PENDING.remove(player.method_5667());
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Action expired. You must confirm within 10 seconds."));
                    return 0;
                }
                PENDING.remove(player.method_5667());
                MigrateCommand.migrateMailboxes((class_2168)context.getSource());
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid confirmation. You must run /mighty_mail:migrate first"));
            return 0;
        }));
    }

    private static int migrateMailboxes(class_2168 source) {
        MinecraftServer server = source.method_9211();
        DeliveryService refurbishedService = DeliveryService.get((MinecraftServer)server).orElse(null);
        if (refurbishedService == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Failed to get mailbox registry from the furniture mod. This should not happen..."));
            return 0;
        }
        com.mrcrayfish.mightymail.mail.DeliveryService service = com.mrcrayfish.mightymail.mail.DeliveryService.get(server).orElse(null);
        if (service == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Failed to get mailbox registry from mighty mail. This should not happen..."));
            return 0;
        }
        AtomicInteger counter = new AtomicInteger(0);
        service.getMailboxes().forEach((uuid, mailbox) -> {
            class_2248 newBlock;
            class_3218 level = server.method_3847(mailbox.levelKey());
            if (level == null) {
                return;
            }
            class_2586 entity = level.method_8321(mailbox.pos());
            if (!(entity instanceof com.mrcrayfish.mightymail.blockentity.MailboxBlockEntity)) {
                return;
            }
            class_2680 state = level.method_8320(mailbox.pos());
            if (!(state.method_26204() instanceof MailboxBlock)) {
                return;
            }
            class_2350 direction = (class_2350)state.method_11654((class_2769)MailboxBlock.DIRECTION);
            boolean enabled = (Boolean)state.method_11654((class_2769)MailboxBlock.ENABLED);
            if (state.method_26204() == ModBlocks.MAIL_BOX_OAK.get()) {
                newBlock = (class_2248)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_OAK.get();
            } else if (state.method_26204() == ModBlocks.MAIL_BOX_SPRUCE.get()) {
                newBlock = (class_2248)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_SPRUCE.get();
            } else if (state.method_26204() == ModBlocks.MAIL_BOX_BIRCH.get()) {
                newBlock = (class_2248)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_BIRCH.get();
            } else if (state.method_26204() == ModBlocks.MAIL_BOX_JUNGLE.get()) {
                newBlock = (class_2248)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_JUNGLE.get();
            } else if (state.method_26204() == ModBlocks.MAIL_BOX_ACACIA.get()) {
                newBlock = (class_2248)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_ACACIA.get();
            } else if (state.method_26204() == ModBlocks.MAIL_BOX_DARK_OAK.get()) {
                newBlock = (class_2248)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_DARK_OAK.get();
            } else if (state.method_26204() == ModBlocks.MAIL_BOX_MANGROVE.get()) {
                newBlock = (class_2248)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_MANGROVE.get();
            } else if (state.method_26204() == ModBlocks.MAIL_BOX_CRIMSON.get()) {
                newBlock = (class_2248)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_CRIMSON.get();
            } else if (state.method_26204() == ModBlocks.MAIL_BOX_WARPED.get()) {
                newBlock = (class_2248)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_WARPED.get();
            } else {
                return;
            }
            class_2680 state1 = (class_2680)((class_2680)newBlock.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)direction)).method_11657((class_2769)class_2741.field_12515, (Comparable)Boolean.valueOf(enabled));
            level.method_8652(mailbox.pos(), state1, 3);
            MailboxBlockEntity newBlockEntity = new MailboxBlockEntity(mailbox.pos(), state1);
            level.method_8438((class_2586)newBlockEntity);
            newBlockEntity.regenerateId();
            Mailbox newMailbox = newBlockEntity.getMailbox();
            newMailbox.customName().setValue((Object)((String)mailbox.customName().getValue()));
            newMailbox.setOwner((UUID)mailbox.owner().getValue());
            counter.incrementAndGet();
        });
        source.method_9226(() -> class_2561.method_43470((String)"Successfully migrated %s mailboxes".formatted(counter.get())).method_27692(class_124.field_1060), false);
        return 1;
    }
}

