/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4917;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_5321;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

public abstract class AbstractModelProvider
implements class_2405 {
    public static final String BLOCK_PATH = "block";
    public static final String ITEM_PATH = "item";
    public static final class_4942 SPAWN_EGG = class_4943.method_25859((String)"template_spawn_egg", (class_4945[])new class_4945[0]);
    private final String modId;
    private final class_7784.class_7489 blockStatePathProvider;
    private final class_7784.class_7489 modelPathProvider;
    private final Set<Object> skipValidation = Sets.newHashSet();

    public AbstractModelProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractModelProvider(String modId, class_7784 packOutput) {
        this.modId = modId;
        this.blockStatePathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "blockstates");
        this.modelPathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "models");
    }

    public void addBlockModels(class_4910 builder) {
    }

    public void addItemModels(class_4915 builder) {
    }

    protected boolean skipValidation() {
        return false;
    }

    protected void skipBlock(class_2248 block) {
        this.skipValidation.add(block);
    }

    protected void skipItem(class_1792 item) {
        this.skipValidation.add(item);
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        HashMap generators = Maps.newHashMap();
        Consumer<class_4917> blockStateOutput = generator -> {
            class_2248 block = generator.method_25743();
            class_4917 blockstategenerator = generators.put(block, generator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate block state definition for " + String.valueOf(block));
            }
        };
        HashMap models = Maps.newHashMap();
        HashSet skippedAutoModels = Sets.newHashSet();
        BiConsumer<class_2960, Supplier> modelOutput = (resourceLocation, supplier) -> {
            if (models.put(resourceLocation, supplier) != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(resourceLocation));
            }
        };
        this.addBlockModels(new class_4910(blockStateOutput, modelOutput, skippedAutoModels::add));
        this.addItemModels(new class_4915(modelOutput));
        List<Object> missingBlocks = !this.skipValidation() ? class_7923.field_41175.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals(this.modId) && !generators.containsKey(entry.getValue())).map(Map.Entry::getValue).filter(Predicate.not(this.skipValidation::contains)).toList() : Collections.emptyList();
        if (!missingBlocks.isEmpty()) {
            throw new IllegalStateException("Missing block state definitions for " + String.valueOf(missingBlocks));
        }
        class_7923.field_41175.method_29722().forEach(entry -> {
            class_1792 item = (class_1792)class_1792.field_8003.get(entry.getValue());
            if (item != null) {
                if (!((class_5321)entry.getKey()).method_29177().method_12836().equals(this.modId) || skippedAutoModels.contains(item)) {
                    return;
                }
                class_2960 resourcelocation = class_4941.method_25840((class_1792)item);
                if (!models.containsKey(resourcelocation)) {
                    models.put(resourcelocation, new class_4940(class_4941.method_25842((class_2248)((class_2248)entry.getValue()))));
                }
            }
        });
        List<Object> missingItems = !this.skipValidation() ? class_7923.field_41178.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals(this.modId) && !models.containsKey(AbstractModelProvider.decorateItemModelLocation(((class_5321)entry.getKey()).method_29177()))).map(Map.Entry::getValue).filter(Predicate.not(this.skipValidation::contains)).toList() : Collections.emptyList();
        if (!missingItems.isEmpty()) {
            throw new IllegalStateException("Missing item models for " + String.valueOf(missingItems));
        }
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = AbstractModelProvider.saveCollection(output, generators, block -> this.blockStatePathProvider.method_44107(block.method_40142().method_40237().method_29177()));
        completableFutureArray[1] = AbstractModelProvider.saveCollection(output, models, arg_0 -> ((class_7784.class_7489)this.modelPathProvider).method_44107(arg_0));
        return CompletableFuture.allOf(completableFutureArray);
    }

    public final String method_10321() {
        return "Model Definitions";
    }

    private static <T> CompletableFuture<?> saveCollection(class_7403 output, Map<T, ? extends Supplier<JsonElement>> map, Function<T, Path> pathExtractor) {
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> {
            Path path = (Path)pathExtractor.apply(entry.getKey());
            JsonElement jsonElement = (JsonElement)((Supplier)entry.getValue()).get();
            return class_2405.method_10320((class_7403)output, (JsonElement)jsonElement, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public static class_2960 getModelLocation(class_2248 block) {
        return AbstractModelProvider.decorateBlockModelLocation(AbstractModelProvider.getLocation(block));
    }

    public static class_2960 decorateBlockModelLocation(class_2960 resourceLocation) {
        return resourceLocation.method_45138("block/");
    }

    public static class_2960 getLocation(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block);
    }

    public static String getName(class_2248 block) {
        return AbstractModelProvider.getLocation(block).method_12832();
    }

    public static class_2960 getModelLocation(class_1792 item) {
        return AbstractModelProvider.decorateItemModelLocation(AbstractModelProvider.getLocation(item));
    }

    public static class_2960 decorateItemModelLocation(class_2960 resourceLocation) {
        return resourceLocation.method_45138("item/");
    }

    public static class_2960 getLocation(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item);
    }

    public static String getName(class_1792 item) {
        return AbstractModelProvider.getLocation(item).method_12832();
    }

    public static class_2960 stripUntil(class_2960 resourceLocation, String s) {
        String path = resourceLocation.method_12832();
        if (path.contains(s)) {
            path = path.substring(path.lastIndexOf(s) + 1);
            return ResourceLocationHelper.fromNamespaceAndPath(resourceLocation.method_12836(), path);
        }
        return resourceLocation;
    }

    public static class_4942 createBlockModelTemplate(class_2960 blockModelLocation, class_4945 ... requiredSlots) {
        return AbstractModelProvider.createBlockModelTemplate(blockModelLocation, "", requiredSlots);
    }

    public static class_4942 createBlockModelTemplate(class_2960 blockModelLocation, String suffix, class_4945 ... requiredSlots) {
        return new class_4942(Optional.of(AbstractModelProvider.decorateBlockModelLocation(blockModelLocation)), Optional.of(suffix), requiredSlots);
    }

    public static class_4942 createItemModelTemplate(class_2960 itemModelLocation, class_4945 ... requiredSlots) {
        return AbstractModelProvider.createItemModelTemplate(itemModelLocation, "", requiredSlots);
    }

    public static class_4942 createItemModelTemplate(class_2960 itemModelLocation, String suffix, class_4945 ... requiredSlots) {
        return new class_4942(Optional.of(AbstractModelProvider.decorateItemModelLocation(itemModelLocation)), Optional.of(suffix), requiredSlots);
    }

    public static class_2960 generateFlatItem(class_2960 resourceLocation, class_4942 modelTemplate, BiConsumer<class_2960, Supplier<JsonElement>> modelOutput) {
        return modelTemplate.method_25852(AbstractModelProvider.decorateItemModelLocation(resourceLocation), class_4944.method_25895((class_2960)AbstractModelProvider.decorateItemModelLocation(resourceLocation)), modelOutput);
    }

    public static class_2960 generateFlatItem(class_1792 item, class_4942 modelTemplate, BiConsumer<class_2960, Supplier<JsonElement>> modelOutput, class_4942.class_8073 factory) {
        return modelTemplate.method_48525(class_4941.method_25840((class_1792)item), class_4944.method_25871((class_1792)item), modelOutput, factory);
    }
}

