/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.handler.CoercedRecipeHandler;
import dev.emi.emi.mixin.accessor.CraftingResultSlotAccessor;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiSidebars;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_8566;
import org.jetbrains.annotations.Nullable;

public class EmiRecipeFiller {
    public static Map<class_3917<?>, List<EmiRecipeHandler<?>>> handlers = Maps.newHashMap();
    public static BiFunction<class_1703, EmiRecipe, EmiRecipeHandler<?>> extraHandlers = (h, r) -> null;

    public static void clear() {
        handlers.clear();
        extraHandlers = (h, r) -> null;
    }

    public static boolean isSupported(EmiRecipe recipe) {
        for (List<EmiRecipeHandler<?>> list : handlers.values()) {
            for (EmiRecipeHandler<?> handler : list) {
                if (!handler.supportsRecipe(recipe) || !handler.alwaysDisplaySupport(recipe)) continue;
                return true;
            }
        }
        class_465<?> hs = EmiApi.getHandledScreen();
        if (hs != null) {
            for (EmiRecipeHandler<?> emiRecipeHandler : EmiRecipeFiller.getAllHandlers(hs)) {
                if (!emiRecipeHandler.supportsRecipe(recipe)) continue;
                return true;
            }
            EmiRecipeHandler<?> emiRecipeHandler = extraHandlers.apply(hs.method_17577(), recipe);
            if (emiRecipeHandler != null && emiRecipeHandler.supportsRecipe(recipe)) {
                return true;
            }
        }
        return false;
    }

    public static <T extends class_1703> List<EmiRecipeHandler<T>> getAllHandlers(class_465<T> screen) {
        if (screen != null) {
            class_3917 type;
            class_1703 screenHandler = screen.method_17577();
            try {
                type = screenHandler instanceof class_1723 ? null : screenHandler.method_17358();
            }
            catch (UnsupportedOperationException e) {
                type = null;
            }
            if ((type != null || screenHandler instanceof class_1723) && handlers.containsKey(type)) {
                return handlers.get(type);
            }
            for (class_1735 slot : screen.method_17577().field_7761) {
                class_1734 crs;
                class_8566 inv;
                if (!(slot instanceof class_1734) || (inv = ((CraftingResultSlotAccessor)(crs = (class_1734)slot)).getInput()) == null || inv.method_17398() <= 0 || inv.method_17397() <= 0) continue;
                return List.of(new CoercedRecipeHandler(crs));
            }
        }
        return List.of();
    }

    @Nullable
    public static <T extends class_1703> EmiRecipeHandler<T> getFirstValidHandler(EmiRecipe recipe, class_465<T> screen) {
        EmiRecipeHandler<?> extra;
        EmiRecipeHandler<Object> ret = null;
        for (EmiRecipeHandler<T> handler : EmiRecipeFiller.getAllHandlers(screen)) {
            if (!handler.supportsRecipe(recipe)) continue;
            ret = handler;
            break;
        }
        if ((ret == null || ret instanceof CoercedRecipeHandler && !(screen instanceof class_490)) && (extra = extraHandlers.apply(screen.method_17577(), recipe)) != null) {
            ret = extra;
        }
        return ret;
    }

    public static <T extends class_1703> boolean performFill(EmiRecipe recipe, class_465<T> screen, EmiCraftContext.Type type, EmiCraftContext.Destination destination, int amount) {
        EmiPlayerInventory inv;
        EmiCraftContext<T> context;
        EmiRecipeHandler<T> handler = EmiRecipeFiller.getFirstValidHandler(recipe, screen);
        if (handler != null && handler.supportsRecipe(recipe) && handler.canCraft(recipe, context = new EmiCraftContext<T>(screen, inv = handler.getInventory(screen), type, destination, amount))) {
            EmiSidebars.craft(recipe);
            boolean crafted = handler.craft(recipe, context);
            if (crafted) {
                class_310.method_1551().method_1507(screen);
            }
            return crafted;
        }
        return false;
    }

    @Nullable
    public static <T extends class_1703> List<class_1799> getStacks(StandardRecipeHandler<T> handler, EmiRecipe recipe, class_465<T> screen, int amount) {
        try {
            class_1703 screenHandler = screen.method_17577();
            if (handler != null) {
                List<class_1735> slots = handler.getInputSources(screenHandler);
                List<class_1735> craftingSlots = handler.getCraftingSlots(recipe, screenHandler);
                List<EmiIngredient> ingredients = recipe.getInputs();
                ArrayList discovered = Lists.newArrayList();
                Object2IntOpenHashMap weightDivider = new Object2IntOpenHashMap();
                for (int i = 0; i < ingredients.size(); ++i) {
                    Object stack;
                    ArrayList d = Lists.newArrayList();
                    EmiIngredient ingredient = ingredients.get(i);
                    List<EmiStack> emiStacks = ingredient.getEmiStacks();
                    if (ingredient.isEmpty()) {
                        discovered.add(null);
                        continue;
                    }
                    for (int e = 0; e < emiStacks.size(); ++e) {
                        stack = emiStacks.get(e);
                        block4: for (class_1735 s : slots) {
                            class_1799 ss = s.method_7677();
                            if (!EmiStack.of(s.method_7677()).isEqual((EmiStack)stack)) continue;
                            Iterator iterator = d.iterator();
                            while (iterator.hasNext()) {
                                DiscoveredItem di = (DiscoveredItem)iterator.next();
                                if (!class_1799.method_31577((class_1799)ss, (class_1799)di.stack)) continue;
                                di.amount += ss.method_7947();
                                continue block4;
                            }
                            d.add(new DiscoveredItem((EmiStack)stack, ss, ss.method_7947(), (int)ingredient.getAmount(), ss.method_7914()));
                        }
                    }
                    DiscoveredItem biggest = null;
                    stack = d.iterator();
                    while (stack.hasNext()) {
                        DiscoveredItem di = (DiscoveredItem)stack.next();
                        if (biggest == null) {
                            biggest = di;
                            continue;
                        }
                        int a = di.amount / (weightDivider.getOrDefault((Object)di.ingredient, 0) + di.consumed);
                        int ba = biggest.amount / (weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
                        if (ba >= a) continue;
                        biggest = di;
                    }
                    if (biggest == null || i >= craftingSlots.size()) {
                        return null;
                    }
                    class_1735 slot = craftingSlots.get(i);
                    if (slot == null) {
                        return null;
                    }
                    weightDivider.put((Object)biggest.ingredient, weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
                    biggest.max = Math.min(biggest.max, slot.method_7675());
                    discovered.add(biggest);
                }
                if (discovered.isEmpty()) {
                    return null;
                }
                ArrayList unique = Lists.newArrayList();
                block7: for (Object di : discovered) {
                    if (di == null) continue;
                    for (DiscoveredItem ui : unique) {
                        if (!class_1799.method_31577((class_1799)((DiscoveredItem)di).stack, (class_1799)ui.stack)) continue;
                        ui.consumed += ((DiscoveredItem)di).consumed;
                        continue block7;
                    }
                    unique.add(new DiscoveredItem(((DiscoveredItem)di).ingredient, ((DiscoveredItem)di).stack, ((DiscoveredItem)di).amount, ((DiscoveredItem)di).consumed, ((DiscoveredItem)di).max));
                }
                int maxAmount = Integer.MAX_VALUE;
                for (DiscoveredItem ui : unique) {
                    if (ui.catalyst()) continue;
                    maxAmount = Math.min(maxAmount, ui.amount / ui.consumed);
                    maxAmount = Math.min(maxAmount, ui.max);
                }
                if ((maxAmount = Math.min(maxAmount, amount + EmiRecipeFiller.batchesAlreadyPresent(recipe, handler, screen))) == 0) {
                    return null;
                }
                ArrayList desired = Lists.newArrayList();
                for (int i = 0; i < discovered.size(); ++i) {
                    DiscoveredItem di = (DiscoveredItem)discovered.get(i);
                    if (di != null) {
                        class_1799 is = di.stack.method_7972();
                        int a = di.catalyst() ? di.consumed : di.consumed * maxAmount;
                        is.method_7939(a);
                        desired.add(is);
                        continue;
                    }
                    desired.add(class_1799.field_8037);
                }
                return desired;
            }
        }
        catch (Exception e) {
            EmiLog.error("Error collecting stacks", e);
        }
        return null;
    }

    public static <T extends class_1703> int batchesAlreadyPresent(EmiRecipe recipe, StandardRecipeHandler<T> handler, class_465<T> screen) {
        List<EmiIngredient> inputs = recipe.getInputs();
        ArrayList stacks = Lists.newArrayList();
        class_1735 output = handler.getOutputSlot(screen.method_17577());
        if (output != null && !output.method_7677().method_7960() && recipe.getOutputs().size() > 0 && !class_1799.method_7973((class_1799)output.method_7677(), (class_1799)recipe.getOutputs().get(0).getItemStack())) {
            return 0;
        }
        for (class_1735 slot : handler.getCraftingSlots(recipe, screen.method_17577())) {
            if (slot != null) {
                stacks.add(slot.method_7677());
                continue;
            }
            stacks.add(class_1799.field_8037);
        }
        long amount = Long.MAX_VALUE;
        block1: for (int i = 0; i < inputs.size(); ++i) {
            EmiIngredient input = inputs.get(i);
            if (input.isEmpty()) {
                if (((class_1799)stacks.get(i)).method_7960()) continue;
                return 0;
            }
            if (i >= stacks.size()) {
                return 0;
            }
            EmiStack es = EmiStack.of((class_1799)stacks.get(i));
            for (EmiStack v : input.getEmiStacks()) {
                if (v.isEmpty() || !v.isEqual(es) || es.getAmount() < v.getAmount()) continue;
                amount = Math.min(amount, es.getAmount() / v.getAmount());
                continue block1;
            }
            return 0;
        }
        if (amount < Long.MAX_VALUE && amount > 0L) {
            return (int)amount;
        }
        return 0;
    }

    public static <T extends class_1703> boolean clientFill(StandardRecipeHandler<T> handler, EmiRecipe recipe, class_465<T> screen, List<class_1799> stacks, EmiCraftContext.Destination destination) {
        class_1703 screenHandler = screen.method_17577();
        if (handler != null && screenHandler.method_34255().method_7960()) {
            class_310 client = class_310.method_1551();
            class_636 manager = client.field_1761;
            class_746 player = client.field_1724;
            List<class_1735> clear = handler.getCraftingSlots(screenHandler);
            for (class_1735 slot : clear) {
                if (slot == null) continue;
                manager.method_2906(screenHandler.field_7763, slot.field_7874, 0, class_1713.field_7794, (class_1657)player);
            }
            List<class_1735> inputs = handler.getInputSources(screenHandler);
            List<class_1735> slots = handler.getCraftingSlots(recipe, screenHandler);
            block1: for (int i = 0; i < stacks.size(); ++i) {
                class_1799 stack = stacks.get(i);
                if (stack.method_7960()) continue;
                if (i >= slots.size()) {
                    return false;
                }
                class_1735 crafting = slots.get(i);
                if (crafting == null) {
                    return false;
                }
                int needed = stack.method_7947();
                for (class_1735 input : inputs) {
                    if (slots.contains(input)) continue;
                    class_1799 is = input.method_7677().method_7972();
                    if (class_1799.method_31577((class_1799)is, (class_1799)stack)) {
                        manager.method_2906(screenHandler.field_7763, input.field_7874, 0, class_1713.field_7790, (class_1657)player);
                        if (is.method_7947() <= needed) {
                            needed -= is.method_7947();
                            manager.method_2906(screenHandler.field_7763, crafting.field_7874, 0, class_1713.field_7790, (class_1657)player);
                        } else {
                            while (needed > 0) {
                                manager.method_2906(screenHandler.field_7763, crafting.field_7874, 1, class_1713.field_7790, (class_1657)player);
                                --needed;
                            }
                            manager.method_2906(screenHandler.field_7763, input.field_7874, 0, class_1713.field_7790, (class_1657)player);
                        }
                    }
                    if (needed != 0) continue;
                    continue block1;
                }
                return false;
            }
            class_1735 slot = handler.getOutputSlot(screenHandler);
            if (slot != null) {
                if (destination == EmiCraftContext.Destination.CURSOR) {
                    manager.method_2906(screenHandler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)player);
                } else if (destination == EmiCraftContext.Destination.INVENTORY) {
                    manager.method_2906(screenHandler.field_7763, slot.field_7874, 0, class_1713.field_7794, (class_1657)player);
                }
            }
            return true;
        }
        return false;
    }

    private static class DiscoveredItem {
        private static final Comparison COMPARISON = Comparison.DEFAULT_COMPARISON;
        public EmiStack ingredient;
        public class_1799 stack;
        public int consumed;
        public int amount;
        public int max;

        public DiscoveredItem(EmiStack ingredient, class_1799 stack, int amount, int consumed, int max) {
            this.ingredient = ingredient;
            this.stack = stack.method_7972();
            this.amount = amount;
            this.consumed = consumed;
            this.max = max;
        }

        public boolean catalyst() {
            return this.ingredient.getRemainder().isEqual(this.ingredient, COMPARISON);
        }
    }
}

