/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.config.ImageResourceConfig;
import dev.ftb.mods.ftblibrary.config.ResourceConfigValue;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSelectorScreen;
import dev.ftb.mods.ftblibrary.config.ui.SearchModeIndex;
import dev.ftb.mods.ftblibrary.config.ui.SelectableResource;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import dev.ftb.mods.ftblibrary.util.SearchTerms;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_5250;
import net.minecraft.class_7764;
import org.jetbrains.annotations.Nullable;

public class SelectImageResourceScreen
extends ResourceSelectorScreen<class_2960> {
    private static final SelectableResource<class_2960> NO_IMAGE = new SelectableResource.ImageResource(ImageResourceConfig.NONE);
    private static List<SelectableResource.ImageResource> cachedImages = null;
    public static final SearchModeIndex<ResourceSearchMode<class_2960>> KNOWN_MODES = (SearchModeIndex)class_156.method_654(new SearchModeIndex(), idx -> idx.appendMode(AllImagesMode.INSTANCE));

    public SelectImageResourceScreen(ResourceConfigValue<class_2960> config, ConfigCallback callback) {
        super(config, callback);
    }

    private static void clearCachedImages() {
        cachedImages = null;
    }

    private static boolean isValidImage(class_2960 id) {
        return !id.method_12832().startsWith("textures/font/");
    }

    @Override
    protected ResourceSelectorScreen.ResourceButton makeResourceButton(Panel panel, @Nullable SelectableResource<class_2960> resource) {
        return new ImageButton(this, panel, Objects.requireNonNullElse(resource, NO_IMAGE));
    }

    @Override
    protected SearchModeIndex<ResourceSearchMode<class_2960>> getSearchModeIndex() {
        return KNOWN_MODES;
    }

    private class ImageButton
    extends ResourceSelectorScreen.ResourceButton {
        protected ImageButton(SelectImageResourceScreen selectImageResourceScreen, Panel panel, SelectableResource<class_2960> resource) {
            super(panel, resource);
        }

        @Override
        public boolean shouldAdd(SearchTerms searchTerms) {
            return searchTerms.match((class_2960)this.getStack(), ((class_2960)this.getStack()).toString(), id -> false);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            class_5250 text = class_2561.method_43470((String)((class_2960)this.getStack()).method_12836()).method_27692(class_124.field_1065).method_27693(":").method_10852((class_2561)class_2561.method_43470((String)((class_2960)this.getStack()).method_12832()).method_27692(class_124.field_1054));
            list.add((class_2561)text);
            if (((Boolean)FTBLibraryClientConfig.IMAGE_MODNAME.get()).booleanValue()) {
                ModUtils.getModName(((class_2960)this.getStack()).method_12836()).ifPresent(name -> list.add((class_2561)class_2561.method_43470((String)name).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056})));
            }
        }
    }

    private static enum AllImagesMode implements ResourceSearchMode<class_2960>
    {
        INSTANCE;


        @Override
        public Icon getIcon() {
            return Icons.ART;
        }

        @Override
        public class_5250 getDisplayName() {
            return class_2561.method_43471((String)"ftblibrary.select_image.all_images");
        }

        @Override
        public Collection<? extends SelectableResource<class_2960>> getAllResources() {
            if (cachedImages == null) {
                ArrayList images = new ArrayList();
                StringUtils.ignoreResourceLocationErrors = true;
                Map textures = Collections.emptyMap();
                try {
                    textures = class_310.method_1551().method_1478().method_14488("textures", t -> t.method_12832().endsWith(".png"));
                }
                catch (Exception ex) {
                    FTBLibrary.LOGGER.error("A mod has a broken resource preventing this list from loading: " + String.valueOf(ex));
                }
                StringUtils.ignoreResourceLocationErrors = false;
                textures.keySet().forEach(rl -> class_2960.method_29186((String)rl.toString()).result().ifPresentOrElse(images::add, () -> FTBLibrary.LOGGER.warn("Image {} has invalid path! Report this to author of '{}'!", rl, (Object)rl.method_12836())));
                cachedImages = images.stream().sorted().map(res -> {
                    class_2960 res1 = class_2960.method_60655((String)res.method_12836(), (String)res.method_12832().substring(9, res.method_12832().length() - 4));
                    class_1058 sprite = class_310.method_1551().method_1554().method_24153(class_1723.field_21668).method_4608(res1);
                    class_7764 contents = sprite.method_45851();
                    if (contents.method_45816().equals((Object)class_1047.method_4539())) {
                        res1 = res;
                    }
                    return new SelectableResource.ImageResource(res1);
                }).toList();
            }
            return cachedImages;
        }
    }

    public static enum ResourceListener implements class_4013
    {
        INSTANCE;


        public void method_14491(class_3300 resourceManager) {
            SelectImageResourceScreen.clearCachedImages();
        }
    }
}

