/*
 * Decompiled with CFR 0.152.
 */
package piotro15.biomeblends.util;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6780;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import piotro15.biomeblends.CommonConfig;

public class BlendBiomeResolver {
    public static class_6780 makeResolver(class_2791 chunk, class_3341 boundingBox, class_3218 level, class_2960 targetBiome, Predicate<class_6880<class_1959>> predicate, class_2394 particleOptions) {
        return (x, y, z, sampler) -> {
            class_2960 oldBiome;
            int quartX = class_5742.method_33101((int)x);
            int quartY = class_5742.method_33101((int)y);
            int quartZ = class_5742.method_33101((int)z);
            class_6880 oldBiomeHolder = chunk.method_16359(x, y, z);
            if (boundingBox.method_47593(quartX, quartY, quartZ) && (oldBiome = level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)((class_1959)oldBiomeHolder.comp_349()))) != null) {
                if (predicate.test(oldBiomeHolder)) {
                    level.method_14199(particleOptions, (double)(quartX + 2), (double)(quartY + 2), (double)(quartZ + 2), 8, 2.0, 2.0, 2.0, 1.0);
                    return level.method_30349().method_30530(class_7924.field_41236).method_40290(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)targetBiome));
                }
                return oldBiomeHolder;
            }
            return oldBiomeHolder;
        };
    }

    public static class_6780 makeNamespaceResolver(class_2791 chunk, class_3341 boundingBox, class_3218 level, String targetNamespace, Optional<class_2960> fallbackBiome, Predicate<class_6880<class_1959>> predicate, class_2394 particleOptions) {
        return (x, y, z, sampler) -> {
            class_2960 oldBiome;
            int quartX = class_5742.method_33101((int)x);
            int quartY = class_5742.method_33101((int)y);
            int quartZ = class_5742.method_33101((int)z);
            class_6880 oldBiomeHolder = chunk.method_16359(x, y, z);
            if (boundingBox.method_47593(quartX, quartY, quartZ) && (oldBiome = level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)((class_1959)oldBiomeHolder.comp_349()))) != null) {
                if (predicate.test(oldBiomeHolder)) {
                    level.method_14199(particleOptions, (double)(quartX + 2), (double)(quartY + 2), (double)(quartZ + 2), 8, 2.0, 2.0, 2.0, 1.0);
                    Optional newBiome = level.method_30349().method_30530(class_7924.field_41236).method_40264(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)targetNamespace, (String)oldBiome.method_12832())));
                    Optional fallbackBiomeHolder = fallbackBiome.flatMap(resourceLocation -> level.method_30349().method_30530(class_7924.field_41236).method_40264(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)resourceLocation)));
                    return newBiome.isPresent() ? (class_6880)newBiome.get() : (fallbackBiomeHolder.isPresent() ? (class_6880)fallbackBiomeHolder.get() : oldBiomeHolder);
                }
                return oldBiomeHolder;
            }
            return oldBiomeHolder;
        };
    }

    private static int quantize(int pos) {
        return class_5742.method_33101((int)class_5742.method_33100((int)pos));
    }

    private static class_2338 quantize(class_2338 blockPos) {
        return new class_2338(BlendBiomeResolver.quantize(blockPos.method_10263()), BlendBiomeResolver.quantize(blockPos.method_10264()), BlendBiomeResolver.quantize(blockPos.method_10260()));
    }

    public static void applyResolver(class_3218 level, class_2338 pos, int horizontalRange, int verticalRange, Predicate<class_6880<class_1959>> predicate, class_2394 particleOptions, BiFunction<class_2791, class_3341, class_6780> resolverFactory) {
        class_3341 boundingBox = BlendBiomeResolver.prepareBoundingBox(pos, (class_1937)level, (int)((double)horizontalRange * CommonConfig.INSTANCE.horizontalScale.getAsDouble()), (int)((double)verticalRange * CommonConfig.INSTANCE.verticalScale.getAsDouble()));
        ArrayList<class_2791> chunks = new ArrayList<class_2791>();
        for (int z = class_4076.method_18675((int)boundingBox.method_35417()); z <= class_4076.method_18675((int)boundingBox.method_35420()); ++z) {
            for (int x = class_4076.method_18675((int)boundingBox.method_35415()); x <= class_4076.method_18675((int)boundingBox.method_35418()); ++x) {
                class_2791 chunk = level.method_8402(x, z, class_2806.field_12803, false);
                if (chunk == null) continue;
                chunks.add(chunk);
            }
        }
        for (class_2791 chunk : chunks) {
            class_6780 resolver = resolverFactory.apply(chunk, boundingBox);
            chunk.method_38257(resolver, level.method_14178().method_41248().method_42371());
            chunk.method_12008(true);
        }
        level.method_14178().field_17254.method_49421(chunks);
    }

    private static class_3341 prepareBoundingBox(class_2338 pos, class_1937 level, int horizontalRange, int verticalRange) {
        class_2338 corner1 = BlendBiomeResolver.quantize(new class_2338(pos.method_10263() - horizontalRange, CommonConfig.INSTANCE.ignoreVerticalRadius.getAsBoolean() || verticalRange == -1 ? level.method_31607() : pos.method_10264() - verticalRange, pos.method_10260() - horizontalRange));
        class_2338 corner2 = BlendBiomeResolver.quantize(new class_2338(pos.method_10263() + horizontalRange, CommonConfig.INSTANCE.ignoreVerticalRadius.getAsBoolean() || verticalRange == -1 ? level.method_31600() : pos.method_10264() + verticalRange, pos.method_10260() + horizontalRange));
        return class_3341.method_34390((class_2382)corner1, (class_2382)corner2);
    }
}

