/*
 * Decompiled with CFR 0.152.
 */
package piotro15.biomeblends;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CommonConfig {
    public static final CommonConfig INSTANCE;
    public static final ModConfigSpec SPEC;
    public final ModConfigSpec.DoubleValue verticalScale;
    public final ModConfigSpec.DoubleValue horizontalScale;
    public final ModConfigSpec.BooleanValue ignoreVerticalRadius;

    private CommonConfig(ModConfigSpec.Builder builder) {
        this.horizontalScale = builder.comment("When any blend is applied, the horizontal radius is multiplied by this number.").defineInRange("horizontal_scale", 1.0, 0.0, 10.0);
        this.verticalScale = builder.comment("When any blend is applied, the vertical radius is multiplied by this number.").defineInRange("vertical_scale", 1.0, 0.0, 10.0);
        this.ignoreVerticalRadius = builder.comment("Causes all blends to be applied from the bottom to the top of the world.").define("ignore_vertical_radius", false);
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        INSTANCE = (CommonConfig)pair.getLeft();
        SPEC = (ModConfigSpec)pair.getRight();
    }
}

