/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.api;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.texture.TextureMappingTool;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_156;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;

public abstract class ChiseledTextureProvider
implements class_2405 {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final String modid;
    private final FabricDataOutput generator;
    private final Map<Pair<class_2960, class_2960>, PaletteMap> textures = new HashMap<Pair<class_2960, class_2960>, PaletteMap>();
    private final Set<String> outputLocations = new HashSet<String>();
    private final List<String> oakPlankSuffixes;

    public ChiseledTextureProvider(String modid, FabricDataOutput generator) {
        this.modid = modid;
        this.generator = generator;
        this.oakPlankSuffixes = TextureMappingTool.getSuffixes("oak_planks");
    }

    public String method_10321() {
        return "Chiseled Textures: " + this.modid;
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.createTextures();
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>();
        Path path = this.generator.method_45971();
        for (Map.Entry<Pair<class_2960, class_2960>, PaletteMap> entry : this.textures.entrySet()) {
            if (entry.getValue().targets.isEmpty()) continue;
            Pair<BufferedImage, JsonObject> oldPalette = this.loadTexture((class_2960)entry.getKey().left());
            Pair<BufferedImage, JsonObject> newPalette = this.loadTexture((class_2960)entry.getKey().right());
            Map<String, class_2960> targets = entry.getValue().targets;
            boolean ignoreMissingColors = entry.getValue().ignoreMissingColors;
            Map<Integer, Integer> colorMap = TextureMappingTool.createPaletteMap((BufferedImage)oldPalette.left(), (BufferedImage)newPalette.left());
            for (Map.Entry<String, class_2960> target : targets.entrySet()) {
                Pair<BufferedImage, JsonObject> targetTexture = this.loadTexture(target.getValue());
                String outputLocation = target.getKey();
                TextureMappingTool.applyPaletteMap((BufferedImage)targetTexture.left(), colorMap, ignoreMissingColors, outputLocation);
                Path texturePath = path.resolve("assets/" + this.modid + "/textures/" + outputLocation + ".png");
                tasks.add(ChiseledTextureProvider.saveTexture(cache, (BufferedImage)targetTexture.left(), texturePath));
                if (targetTexture.right() == null) continue;
                Path textureMetadataPath = path.resolve("assets/" + this.modid + "/textures/" + outputLocation + ".png.mcmeta");
                tasks.add(class_2405.method_10320((class_7403)cache, (JsonElement)((JsonElement)targetTexture.right()), (Path)textureMetadataPath));
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new));
    }

    private Pair<BufferedImage, JsonObject> loadTexture(class_2960 location) {
        BufferedImage image;
        class_2960 fullLocation = class_2960.method_60655((String)location.method_12836(), (String)("textures/" + location.method_12832() + ".png"));
        if (!TextureMappingTool.exists(fullLocation)) {
            throw new IllegalStateException("Could not find existing texture: " + String.valueOf(location));
        }
        class_2960 metadataLocation = class_2960.method_60655((String)location.method_12836(), (String)("textures/" + location.method_12832() + ".png.mcmeta"));
        boolean hasMetadata = TextureMappingTool.exists(metadataLocation);
        JsonObject metadata = null;
        if (hasMetadata) {
            try (BufferedReader reader = TextureMappingTool.getResource(metadataLocation).method_43039();){
                metadata = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception when trying to load texture metadata: " + String.valueOf(metadataLocation), e);
            }
        }
        try (InputStream stream = TextureMappingTool.getResource(fullLocation).method_14482();){
            image = ImageIO.read(stream);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception when trying to load texture: " + String.valueOf(location), e);
        }
        if (image.getType() != 2) {
            BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D graphics = newImage.createGraphics();
            graphics.drawImage((Image)image, 0, 0, null);
            graphics.dispose();
            image = newImage;
        }
        return Pair.of((Object)image, (Object)metadata);
    }

    private static CompletableFuture<?> saveTexture(class_7403 cache, BufferedImage image, Path path) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                HashingOutputStream hashingStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteStream);
                ImageIO.write((RenderedImage)image, "png", (OutputStream)hashingStream);
                cache.method_43346(path, byteStream.toByteArray(), hashingStream.hash());
            }
            catch (IOException iOException) {
                field_40831.error("Couldn't save texture to {}", (Object)path, (Object)iOException);
            }
        }, class_156.method_18349());
    }

    private boolean validateTexture(class_2960 texture) {
        class_2960 fullLocation = class_2960.method_60655((String)texture.method_12836(), (String)("textures/" + texture.method_12832() + ".png"));
        return TextureMappingTool.exists(fullLocation);
    }

    protected abstract void createTextures();

    protected PaletteMap createPaletteMap(class_2960 oldPalette, class_2960 newPalette) {
        if (!this.validateTexture(oldPalette)) {
            throw new IllegalStateException("Could not find texture '" + String.valueOf(oldPalette) + "'!");
        }
        if (!this.validateTexture(newPalette)) {
            throw new IllegalStateException("Could not find texture '" + String.valueOf(newPalette) + "'!");
        }
        return this.textures.computeIfAbsent((Pair<class_2960, class_2960>)Pair.of((Object)oldPalette, (Object)newPalette), o -> new PaletteMap());
    }

    protected void createPlankTextures(class_2960 plankTexture, String outputLocation) {
        if (!this.validateTexture(plankTexture)) {
            throw new IllegalStateException("Could not find texture '" + String.valueOf(plankTexture) + "'!");
        }
        if (outputLocation == null || outputLocation.trim().isEmpty()) {
            throw new IllegalArgumentException("Output location must not be empty!");
        }
        if (!this.outputLocations.add(outputLocation)) {
            throw new IllegalStateException("Two or more textures have the same output location: " + outputLocation);
        }
        PaletteMap paletteMap = this.createPaletteMap(class_2960.method_60655((String)"minecraft", (String)"block/oak_planks"), plankTexture);
        for (String suffix : this.oakPlankSuffixes) {
            paletteMap.applyToTexture(class_2960.method_60655((String)"rechiseled", (String)("block/oak_planks" + suffix)), outputLocation + suffix);
        }
    }

    protected class PaletteMap {
        private final Map<String, class_2960> targets = new HashMap<String, class_2960>();
        private boolean ignoreMissingColors = false;

        private PaletteMap() {
        }

        public PaletteMap applyToTexture(class_2960 texture, String outputLocation) {
            if (!ChiseledTextureProvider.this.validateTexture(texture)) {
                throw new IllegalStateException("Could not find texture '" + String.valueOf(texture) + "'!");
            }
            if (outputLocation == null || outputLocation.trim().isEmpty()) {
                throw new IllegalArgumentException("Output location must not be empty!");
            }
            if (!ChiseledTextureProvider.this.outputLocations.add(outputLocation)) {
                throw new IllegalStateException("Two or more textures have the same output location: " + outputLocation);
            }
            this.targets.put(outputLocation.toLowerCase(Locale.ROOT).trim(), texture);
            return this;
        }

        public PaletteMap ignoreMissing() {
            this.ignoreMissingColors = true;
            return this;
        }
    }
}

