/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.world.level.block.entity;

import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ClientConfig;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_479;

public class CraftingTableAnimationController {
    private final class_243 position;
    public int ticks;
    public float currentAngle;
    public float nextAngle;
    public int sector;
    public boolean animating;
    public float animationAngleStart;
    public float animationAngleEnd;
    public double startTicks;
    public double playerAngle;

    public CraftingTableAnimationController(class_2338 blockPos) {
        this.position = blockPos.method_46558();
    }

    public void tick(class_1937 level) {
        ++this.ticks;
        this.setPlayerAngle(level);
        this.setCurrentSector();
        this.tryAnimate();
    }

    private void setPlayerAngle(class_1937 level) {
        class_1657 player = ((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).rotateIngredients != ClientConfig.RotateIngredients.NEVER ? level.method_8604(this.position.method_10216(), this.position.method_10214(), this.position.method_10215(), 3.0, entity -> {
            if (entity.method_7325()) {
                return false;
            }
            if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).rotateIngredients == ClientConfig.RotateIngredients.CLOSEST_PLAYER) {
                return true;
            }
            if (entity == Proxy.INSTANCE.getClientPlayer()) {
                return class_310.method_1551().field_1755 instanceof class_479;
            }
            return false;
        }) : null;
        if (player != null) {
            double d0 = player.method_23317() - this.position.method_10216();
            double d1 = player.method_23321() - this.position.method_10215();
            this.playerAngle = (Math.atan2(-d0, -d1) + 3.9269908169872414) % (Math.PI * 2);
        }
    }

    private void setCurrentSector() {
        int sector = (int)(this.playerAngle * 2.0 / Math.PI);
        if (this.sector != sector) {
            this.animating = true;
            this.animationAngleStart = this.currentAngle;
            float delta1 = (float)sector * 90.0f - this.currentAngle;
            float abs1 = Math.abs(delta1);
            float delta2 = delta1 + 360.0f;
            float shift = Math.abs(delta2);
            float delta3 = delta1 - 360.0f;
            float abs3 = Math.abs(delta3);
            this.animationAngleEnd = abs3 < abs1 && abs3 < shift ? delta3 + this.currentAngle : (shift < abs1 && shift < abs3 ? delta2 + this.currentAngle : delta1 + this.currentAngle);
            this.startTicks = this.ticks;
            this.sector = sector;
        }
    }

    private void tryAnimate() {
        if (this.animating) {
            if ((double)this.ticks >= this.startTicks + 20.0) {
                this.animating = false;
                this.currentAngle = this.nextAngle = (this.animationAngleEnd + 360.0f) % 360.0f;
            } else {
                this.currentAngle = (CraftingTableAnimationController.calcEaseOutQuad((double)this.ticks - this.startTicks, this.animationAngleStart, this.animationAngleEnd - this.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                this.nextAngle = (CraftingTableAnimationController.calcEaseOutQuad(Math.min((double)(this.ticks + 1) - this.startTicks, 20.0), this.animationAngleStart, this.animationAngleEnd - this.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                if (this.currentAngle != 0.0f || this.nextAngle != 0.0f) {
                    if (this.currentAngle == 0.0f && this.nextAngle >= 180.0f) {
                        this.currentAngle = 360.0f;
                    }
                    if (this.nextAngle == 0.0f && this.currentAngle >= 180.0f) {
                        this.nextAngle = 360.0f;
                    }
                }
            }
        }
    }

    private static float calcEaseOutQuad(double t, float b, float c, double d) {
        float z = (float)t / (float)d;
        return -c * z * (z - 2.0f) + b;
    }
}

