/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.ssl;

import com.vecoo.extralib.shade.postgresql.PGProperty;
import com.vecoo.extralib.shade.postgresql.core.PGStream;
import com.vecoo.extralib.shade.postgresql.core.SocketFactoryFactory;
import com.vecoo.extralib.shade.postgresql.jdbc.SslMode;
import com.vecoo.extralib.shade.postgresql.jdbc.SslNegotiation;
import com.vecoo.extralib.shade.postgresql.ssl.LibPQFactory;
import com.vecoo.extralib.shade.postgresql.ssl.PGjdbcHostnameVerifier;
import com.vecoo.extralib.shade.postgresql.util.GT;
import com.vecoo.extralib.shade.postgresql.util.ObjectFactory;
import com.vecoo.extralib.shade.postgresql.util.PSQLException;
import com.vecoo.extralib.shade.postgresql.util.PSQLState;
import com.vecoo.extralib.shade.postgresql.util.internal.Nullness;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class MakeSSL
extends ObjectFactory {
    private static final Logger LOGGER = Logger.getLogger(MakeSSL.class.getName());

    public static void convert(PGStream stream, Properties info) throws PSQLException, IOException {
        SslMode sslMode;
        SSLSocket newConnection;
        LOGGER.log(Level.FINE, "converting regular socket connection to ssl");
        SSLSocketFactory factory = SocketFactoryFactory.getSslSocketFactory(info);
        try {
            newConnection = (SSLSocket)factory.createSocket(stream.getSocket(), stream.getHostSpec().getHost(), stream.getHostSpec().getPort(), true);
            int connectTimeoutSeconds = PGProperty.CONNECT_TIMEOUT.getInt(info);
            newConnection.setSoTimeout(connectTimeoutSeconds * 1000);
            if (SslNegotiation.of(Nullness.castNonNull(PGProperty.SSL_NEGOTIATION.getOrDefault(info))) == SslNegotiation.DIRECT) {
                SSLParameters sslParameters = newConnection.getSSLParameters();
                sslParameters.setApplicationProtocols(new String[]{"postgresql"});
                newConnection.setSSLParameters(sslParameters);
            }
            newConnection.setUseClientMode(true);
            newConnection.startHandshake();
        }
        catch (IOException ex) {
            throw new PSQLException(GT.tr("SSL error: {0}", ex.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
        if (factory instanceof LibPQFactory) {
            ((LibPQFactory)factory).throwKeyManagerException();
        }
        if ((sslMode = SslMode.of(info)).verifyPeerName()) {
            MakeSSL.verifyPeerName(stream, info, newConnection);
        }
        int socketTimeout = PGProperty.SOCKET_TIMEOUT.getInt(info);
        newConnection.setSoTimeout(socketTimeout * 1000);
        stream.changeSocket(newConnection);
    }

    private static void verifyPeerName(PGStream stream, Properties info, SSLSocket newConnection) throws PSQLException {
        HostnameVerifier hvn;
        String sslhostnameverifier = PGProperty.SSL_HOSTNAME_VERIFIER.getOrDefault(info);
        if (sslhostnameverifier == null) {
            hvn = PGjdbcHostnameVerifier.INSTANCE;
            sslhostnameverifier = "PgjdbcHostnameVerifier";
        } else {
            try {
                hvn = MakeSSL.instantiate(HostnameVerifier.class, sslhostnameverifier, info, false, null);
            }
            catch (Exception e) {
                throw new PSQLException(GT.tr("The HostnameVerifier class provided {0} could not be instantiated.", sslhostnameverifier), PSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        }
        if (hvn.verify(stream.getHostSpec().getHost(), newConnection.getSession())) {
            return;
        }
        throw new PSQLException(GT.tr("The hostname {0} could not be verified by hostnameverifier {1}.", stream.getHostSpec().getHost(), sslhostnameverifier), PSQLState.CONNECTION_FAILURE);
    }
}

