/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common;

import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.AbstractScramMessage;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.Gs2CbindFlag;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.Gs2Header;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ScramAttributeValue;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ScramAttributes;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ScramStringFormatting;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.StringWritableCsv;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClientFinalMessage
extends AbstractScramMessage {
    private final String cbindInput;
    private final String nonce;
    private final byte[] proof;

    public ClientFinalMessage(Gs2Header gs2Header, byte[] cbindData, String nonce, byte[] proof) {
        this.cbindInput = ClientFinalMessage.generateCBindInput(gs2Header, cbindData);
        this.nonce = Preconditions.checkNotEmpty(nonce, "nonce");
        this.proof = (byte[])Preconditions.checkNotNull(proof, "proof").clone();
    }

    public String getCbindInput() {
        return this.cbindInput;
    }

    public String getNonce() {
        return this.nonce;
    }

    public byte[] getProof() {
        return (byte[])this.proof.clone();
    }

    private static void checkChannelBinding(Gs2Header gs2Header, byte[] cbindData) {
        Gs2CbindFlag channelBindingFlag = gs2Header.getChannelBindingFlag();
        if (channelBindingFlag == Gs2CbindFlag.CHANNEL_BINDING_REQUIRED && null == cbindData) {
            throw new IllegalArgumentException("Channel binding data is required");
        }
        if (channelBindingFlag != Gs2CbindFlag.CHANNEL_BINDING_REQUIRED && null != cbindData) {
            throw new IllegalArgumentException("Channel binding data should not be present");
        }
    }

    @NotNull
    private static String generateCBindInput(@NotNull Gs2Header gs2Header, byte @Nullable [] cbindData) {
        Preconditions.checkNotNull(gs2Header, "gs2Header");
        ClientFinalMessage.checkChannelBinding(gs2Header, cbindData);
        byte[] cbindInput = gs2Header.writeTo(new StringBuilder(32)).append(',').toString().getBytes(StandardCharsets.UTF_8);
        if (null != cbindData && cbindData.length != 0) {
            byte[] cbindInputNew = new byte[cbindInput.length + cbindData.length];
            System.arraycopy(cbindInput, 0, cbindInputNew, 0, cbindInput.length);
            System.arraycopy(cbindData, 0, cbindInputNew, cbindInput.length, cbindData.length);
            cbindInput = cbindInputNew;
        }
        return ScramStringFormatting.base64Encode(cbindInput);
    }

    private StringBuilder writeToWithoutProof(@NotNull StringBuilder sb) {
        return StringWritableCsv.writeTo(sb, new ScramAttributeValue(ScramAttributes.CHANNEL_BINDING, this.cbindInput), new ScramAttributeValue(ScramAttributes.NONCE, this.nonce));
    }

    static StringBuilder withoutProof(StringBuilder sb, Gs2Header gs2Header, byte[] cbindData, String nonce) {
        return StringWritableCsv.writeTo(sb, new ScramAttributeValue(ScramAttributes.CHANNEL_BINDING, ClientFinalMessage.generateCBindInput(gs2Header, cbindData)), new ScramAttributeValue(ScramAttributes.NONCE, nonce));
    }

    @Override
    StringBuilder writeTo(StringBuilder sb) {
        this.writeToWithoutProof(sb);
        return StringWritableCsv.writeTo(sb, null, new ScramAttributeValue(ScramAttributes.CLIENT_PROOF, ScramStringFormatting.base64Encode(this.proof)));
    }
}

