/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.replication;

import com.vecoo.extralib.shade.postgresql.core.BaseConnection;
import com.vecoo.extralib.shade.postgresql.replication.PGReplicationConnection;
import com.vecoo.extralib.shade.postgresql.replication.fluent.ChainedCreateReplicationSlotBuilder;
import com.vecoo.extralib.shade.postgresql.replication.fluent.ChainedStreamBuilder;
import com.vecoo.extralib.shade.postgresql.replication.fluent.ReplicationCreateSlotBuilder;
import com.vecoo.extralib.shade.postgresql.replication.fluent.ReplicationStreamBuilder;
import java.sql.SQLException;
import java.sql.Statement;

public class PGReplicationConnectionImpl
implements PGReplicationConnection {
    private final BaseConnection connection;

    public PGReplicationConnectionImpl(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    public ChainedStreamBuilder replicationStream() {
        return new ReplicationStreamBuilder(this.connection);
    }

    @Override
    public ChainedCreateReplicationSlotBuilder createReplicationSlot() {
        return new ReplicationCreateSlotBuilder(this.connection);
    }

    @Override
    public void dropReplicationSlot(String slotName) throws SQLException {
        if (slotName == null || slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slot name can't be null or empty");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DROP_REPLICATION_SLOT " + slotName);
        }
    }
}

