/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.core;

import com.vecoo.extralib.shade.checkerframework.checker.nullness.qual.Nullable;
import com.vecoo.extralib.shade.postgresql.core.Field;
import com.vecoo.extralib.shade.postgresql.core.Query;
import com.vecoo.extralib.shade.postgresql.core.ResultCursor;
import com.vecoo.extralib.shade.postgresql.core.ResultHandler;
import com.vecoo.extralib.shade.postgresql.core.Tuple;
import com.vecoo.extralib.shade.postgresql.util.internal.Nullness;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;

public class ResultHandlerBase
implements ResultHandler {
    private @Nullable SQLException firstException;
    private @Nullable SQLException lastException;
    private @Nullable SQLWarning firstWarning;
    private @Nullable SQLWarning lastWarning;

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, @Nullable ResultCursor cursor) {
    }

    @Override
    public void handleCommandStatus(String status, long updateCount, long insertOID) {
    }

    @Override
    public void secureProgress() {
    }

    @Override
    public void handleWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = this.lastWarning = warning;
            return;
        }
        SQLWarning lastWarning = Nullness.castNonNull(this.lastWarning);
        lastWarning.setNextException(warning);
        this.lastWarning = warning;
    }

    @Override
    public void handleError(SQLException error) {
        if (this.firstException == null) {
            this.firstException = this.lastException = error;
            return;
        }
        Nullness.castNonNull(this.lastException).setNextException(error);
        this.lastException = error;
    }

    @Override
    public void handleCompletion() throws SQLException {
        SQLException firstException = this.firstException;
        if (firstException != null) {
            throw firstException;
        }
    }

    @Override
    public @Nullable SQLException getException() {
        return this.firstException;
    }

    @Override
    public @Nullable SQLWarning getWarning() {
        return this.firstWarning;
    }
}

