/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mysql.cj.result;

import com.vecoo.extralib.shade.mysql.cj.Messages;
import com.vecoo.extralib.shade.mysql.cj.conf.PropertyKey;
import com.vecoo.extralib.shade.mysql.cj.conf.PropertySet;
import com.vecoo.extralib.shade.mysql.cj.exceptions.DataConversionException;
import com.vecoo.extralib.shade.mysql.cj.protocol.a.MysqlTextValueDecoder;
import com.vecoo.extralib.shade.mysql.cj.result.DefaultValueFactory;
import com.vecoo.extralib.shade.mysql.cj.result.Field;
import com.vecoo.extralib.shade.mysql.cj.util.StringUtils;
import java.util.regex.Pattern;

public abstract class AbstractNumericValueFactory<T>
extends DefaultValueFactory<T> {
    public static final Pattern FLOATING_POINT_PTRN = Pattern.compile("-?\\d*\\.\\d*");
    public static final Pattern INTEGER_PTRN = Pattern.compile("-?\\d+");

    public AbstractNumericValueFactory(PropertySet pset) {
        super(pset);
    }

    @Override
    public T createFromBytes(byte[] bytes, int offset, int length, Field f) {
        if (length == 0 && this.pset.getBooleanProperty(PropertyKey.emptyStringsConvertToZero).getValue().booleanValue()) {
            return this.createFromLong(0L);
        }
        String s2 = StringUtils.toString(bytes, offset, length, f.getEncoding());
        byte[] newBytes = s2.getBytes();
        if (s2.contains("e") || s2.contains("E") || FLOATING_POINT_PTRN.matcher(s2).matches()) {
            return this.createFromDouble(MysqlTextValueDecoder.getDouble(newBytes, 0, newBytes.length));
        }
        if (INTEGER_PTRN.matcher(s2).matches()) {
            if (s2.charAt(0) == '-' || length <= 19 && newBytes[0] >= 48 && newBytes[0] <= 56) {
                return this.createFromLong(MysqlTextValueDecoder.getLong(newBytes, 0, newBytes.length));
            }
            return this.createFromBigInteger(MysqlTextValueDecoder.getBigInteger(newBytes, 0, newBytes.length));
        }
        throw new DataConversionException(Messages.getString("ResultSet.UnableToInterpretString", new Object[]{s2}));
    }

    @Override
    public T createFromYear(long l) {
        return this.createFromLong(l);
    }
}

