/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.client.result.rowdecoder;

import com.vecoo.extralib.shade.mariadb.jdbc.client.ColumnDecoder;
import com.vecoo.extralib.shade.mariadb.jdbc.client.Context;
import com.vecoo.extralib.shade.mariadb.jdbc.client.impl.StandardReadableByteBuf;
import com.vecoo.extralib.shade.mariadb.jdbc.client.result.rowdecoder.RowDecoder;
import com.vecoo.extralib.shade.mariadb.jdbc.client.util.MutableInt;
import com.vecoo.extralib.shade.mariadb.jdbc.plugin.Codec;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TextRowDecoder
implements RowDecoder {
    @Override
    public <T> T decode(Codec<T> codec, Calendar cal, StandardReadableByteBuf rowBuf, MutableInt fieldLength, ColumnDecoder[] metadataList, MutableInt fieldIndex, Context context) throws SQLException {
        return codec.decodeText(rowBuf, fieldLength, metadataList[fieldIndex.get()], cal, context);
    }

    @Override
    public Object defaultDecode(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength, Context context) throws SQLException {
        return metadataList[fieldIndex.get()].getDefaultText(rowBuf, fieldLength, context);
    }

    @Override
    public String decodeString(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength, Context context) throws SQLException {
        return metadataList[fieldIndex.get()].decodeStringText(rowBuf, fieldLength, null, context);
    }

    @Override
    public byte decodeByte(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeByteText(rowBuf, fieldLength);
    }

    @Override
    public boolean decodeBoolean(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeBooleanText(rowBuf, fieldLength);
    }

    @Override
    public Date decodeDate(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength, Calendar cal, Context context) throws SQLException {
        return metadataList[fieldIndex.get()].decodeDateText(rowBuf, fieldLength, cal, context);
    }

    @Override
    public Time decodeTime(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength, Calendar cal, Context context) throws SQLException {
        return metadataList[fieldIndex.get()].decodeTimeText(rowBuf, fieldLength, cal, context);
    }

    @Override
    public Timestamp decodeTimestamp(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength, Calendar cal, Context context) throws SQLException {
        return metadataList[fieldIndex.get()].decodeTimestampText(rowBuf, fieldLength, cal, context);
    }

    @Override
    public short decodeShort(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeShortText(rowBuf, fieldLength);
    }

    @Override
    public int decodeInt(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeIntText(rowBuf, fieldLength);
    }

    @Override
    public long decodeLong(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeLongText(rowBuf, fieldLength);
    }

    @Override
    public float decodeFloat(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeFloatText(rowBuf, fieldLength);
    }

    @Override
    public double decodeDouble(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeDoubleText(rowBuf, fieldLength);
    }

    @Override
    public boolean wasNull(byte[] nullBitmap, MutableInt fieldIndex, MutableInt fieldLength) {
        return fieldLength.get() == -1;
    }

    @Override
    public int setPosition(int newIndex, MutableInt fieldIndex, int maxIndex, StandardReadableByteBuf rowBuf, byte[] nullBitmap, ColumnDecoder[] metadataList) {
        if (fieldIndex.get() >= newIndex) {
            fieldIndex.set(0);
            rowBuf.pos(0);
        } else {
            fieldIndex.incrementAndGet();
        }
        while (fieldIndex.get() < newIndex) {
            rowBuf.skipLengthEncoded();
            fieldIndex.incrementAndGet();
        }
        byte len = rowBuf.buf[rowBuf.pos++];
        switch (len) {
            case -5: {
                return -1;
            }
            case -4: {
                return rowBuf.readUnsignedShort();
            }
            case -3: {
                return rowBuf.readUnsignedMedium();
            }
            case -2: {
                int fieldLength = (int)rowBuf.readUnsignedInt();
                rowBuf.skip(4);
                return fieldLength;
            }
        }
        return len & 0xFF;
    }
}

