/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Locale;

public class CallableParameterMetaData
implements ParameterMetaData {
    private final ResultSet rs;
    private final int parameterCount;
    private final boolean isFunction;

    public CallableParameterMetaData(ResultSet rs, boolean isFunction) throws SQLException {
        this.rs = rs;
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        this.parameterCount = count;
        this.isFunction = isFunction;
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public int isNullable(int index) throws SQLException {
        this.setIndex(index);
        return 2;
    }

    private void setIndex(int index) throws SQLException {
        if (index < 1 || index > this.parameterCount) {
            throw new SQLException("invalid parameter index " + index);
        }
        this.rs.absolute(index);
    }

    @Override
    public boolean isSigned(int index) throws SQLException {
        this.setIndex(index);
        String paramDetail = this.rs.getString("DTD_IDENTIFIER");
        return !paramDetail.contains(" unsigned");
    }

    @Override
    public int getPrecision(int index) throws SQLException {
        this.setIndex(index);
        int characterMaxLength = this.rs.getInt("CHARACTER_MAXIMUM_LENGTH");
        int numericPrecision = this.rs.getInt("NUMERIC_PRECISION");
        return numericPrecision > 0 ? numericPrecision : characterMaxLength;
    }

    @Override
    public int getScale(int index) throws SQLException {
        this.setIndex(index);
        return this.rs.getInt("NUMERIC_SCALE");
    }

    public String getParameterName(int index) throws SQLException {
        this.setIndex(index);
        return this.rs.getString("PARAMETER_NAME");
    }

    @Override
    public int getParameterType(int index) throws SQLException {
        String str;
        this.setIndex(index);
        switch (str = this.rs.getString("DATA_TYPE").toUpperCase(Locale.ROOT)) {
            case "BIT": {
                return -7;
            }
            case "TINYINT": {
                if ("TINYINT(1)".equals(this.rs.getString("DTD_IDENTIFIER").toUpperCase(Locale.ROOT))) {
                    return 16;
                }
                return -6;
            }
            case "SMALLINT": 
            case "YEAR": {
                return 5;
            }
            case "MEDIUMINT": 
            case "INT": 
            case "INT24": 
            case "INTEGER": {
                return 4;
            }
            case "LONG": 
            case "BIGINT": {
                return -5;
            }
            case "REAL": 
            case "DOUBLE": {
                return 8;
            }
            case "FLOAT": {
                return 6;
            }
            case "DECIMAL": {
                return 3;
            }
            case "CHAR": {
                return 1;
            }
            case "VARCHAR": 
            case "ENUM": 
            case "TINYTEXT": 
            case "SET": {
                return 12;
            }
            case "DATE": {
                return 91;
            }
            case "TIME": {
                return 92;
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                return 93;
            }
            case "BINARY": {
                return -2;
            }
            case "VARBINARY": {
                return -3;
            }
            case "TINYBLOB": 
            case "BLOB": 
            case "MEDIUMBLOB": 
            case "LONGBLOB": 
            case "GEOMETRY": {
                return 2004;
            }
            case "TEXT": 
            case "MEDIUMTEXT": 
            case "LONGTEXT": {
                return 2005;
            }
        }
        return 1111;
    }

    @Override
    public String getParameterTypeName(int index) throws SQLException {
        this.setIndex(index);
        if ("TINYINT(1)".equals(this.rs.getString("DTD_IDENTIFIER").toUpperCase(Locale.ROOT))) {
            return "BOOLEAN";
        }
        return this.rs.getString("DATA_TYPE").toUpperCase(Locale.ROOT);
    }

    @Override
    public String getParameterClassName(int index) throws SQLException {
        String str;
        this.setIndex(index);
        switch (str = this.rs.getString("DATA_TYPE").toUpperCase(Locale.ROOT)) {
            case "BIT": {
                return BitSet.class.getName();
            }
            case "TINYINT": {
                if ("TINYINT(1)".equals(this.rs.getString("DTD_IDENTIFIER").toUpperCase(Locale.ROOT))) {
                    return Boolean.TYPE.getName();
                }
                return Byte.TYPE.getName();
            }
            case "SMALLINT": 
            case "YEAR": {
                return Short.TYPE.getName();
            }
            case "MEDIUMINT": 
            case "INT": 
            case "INTEGER": {
                return Integer.TYPE.getName();
            }
            case "BINARY": 
            case "SET": 
            case "GEOMETRY": 
            case "VARBINARY": 
            case "TINYBLOB": {
                return byte[].class.getName();
            }
            case "BIGINT": {
                return Long.TYPE.getName();
            }
            case "FLOAT": {
                return Float.TYPE.getName();
            }
            case "DECIMAL": {
                return BigDecimal.class.getName();
            }
            case "REAL": 
            case "DOUBLE": {
                return Double.TYPE.getName();
            }
            case "CHAR": 
            case "VARCHAR": 
            case "ENUM": 
            case "TINYTEXT": {
                return String.class.getName();
            }
            case "TEXT": 
            case "MEDIUMTEXT": 
            case "LONGTEXT": {
                return Clob.class.getName();
            }
            case "DATE": {
                return Date.class.getName();
            }
            case "TIME": {
                return Time.class.getName();
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                return Timestamp.class.getName();
            }
            case "BLOB": 
            case "MEDIUMBLOB": 
            case "LONGBLOB": {
                return Blob.class.getName();
            }
        }
        return Object.class.getName();
    }

    @Override
    public int getParameterMode(int index) throws SQLException {
        String str;
        this.setIndex(index);
        if (this.isFunction) {
            return 4;
        }
        switch (str = this.rs.getString("PARAMETER_MODE")) {
            case "IN": {
                return 1;
            }
            case "OUT": {
                return 4;
            }
            case "INOUT": {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("The receiver is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }
}

