/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.entity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1299;
import net.minecraft.class_5617;
import net.minecraft.class_5619;
import net.minecraft.class_7923;
import net.minecraft.class_897;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.entity.ErroredEntityRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityRendererMap
implements Map<class_1299<?>, class_897<?>> {
    private final Map<class_1299<?>, class_5617<?>> rendererProviders;
    private final LoadingCache<class_1299<?>, Optional<class_897<?>>> rendererMap;
    private final class_5617.class_5618 context;

    public EntityRendererMap(Map<class_1299<?>, class_5617<?>> rendererProviders, class_5617.class_5618 context) {
        this.rendererProviders = rendererProviders;
        this.context = context;
        this.rendererMap = CacheBuilder.newBuilder().build((CacheLoader)new RenderConstructor());
    }

    @Override
    public int size() {
        return this.rendererProviders.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rendererProviders.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.rendererProviders.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return false;
    }

    @Override
    public class_897<?> get(Object o) {
        try {
            Optional renderer = (Optional)this.rendererMap.get((Object)((class_1299)o));
            return renderer.orElse(null);
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public class_897<?> put(class_1299<?> entityType, class_897<?> entityRenderer) {
        Optional old = (Optional)this.rendererMap.getIfPresent(entityType);
        this.rendererMap.put(entityType, Optional.ofNullable(entityRenderer));
        return old != null ? (class_897)old.orElse(null) : null;
    }

    @Override
    public class_897<?> remove(Object o) {
        Optional old = (Optional)this.rendererMap.getIfPresent(o);
        this.rendererMap.invalidate(o);
        return old != null ? (class_897)old.orElse(null) : null;
    }

    @Override
    public void putAll(@NotNull Map<? extends class_1299<?>, ? extends class_897<?>> map) {
        this.rendererMap.putAll(Maps.transformValues(map, Optional::ofNullable));
    }

    @Override
    public void clear() {
        this.rendererMap.invalidateAll();
    }

    @Override
    @NotNull
    public Set<class_1299<?>> keySet() {
        return this.rendererProviders.keySet();
    }

    @Override
    @NotNull
    public Collection<class_897<?>> values() {
        return new AbstractCollection<class_897<?>>(){

            @Override
            public Iterator<class_897<?>> iterator() {
                return Iterators.transform((Iterator)Iterators.unmodifiableIterator(EntityRendererMap.this.rendererProviders.keySet().iterator()), EntityRendererMap.this::get);
            }

            @Override
            public int size() {
                return EntityRendererMap.this.rendererProviders.size();
            }
        };
    }

    @Override
    @NotNull
    public Set<Map.Entry<class_1299<?>, class_897<?>>> entrySet() {
        return new AbstractSet<Map.Entry<class_1299<?>, class_897<?>>>(){

            @Override
            public Iterator<Map.Entry<class_1299<?>, class_897<?>>> iterator() {
                return Iterators.transform((Iterator)Iterators.unmodifiableIterator(EntityRendererMap.this.rendererProviders.keySet().iterator()), x$0 -> new Entry((class_1299<?>)x$0));
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    return EntityRendererMap.this.rendererProviders.containsKey(e.getKey()) && Objects.equals(EntityRendererMap.this.get(e.getKey()), e.getValue());
                }
                return false;
            }

            @Override
            public int size() {
                return EntityRendererMap.this.rendererProviders.size();
            }
        };
    }

    class RenderConstructor
    extends CacheLoader<class_1299<?>, Optional<class_897<?>>> {
        RenderConstructor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Optional<class_897<?>> load(class_1299<?> key) throws Exception {
            class_5617<?> provider = EntityRendererMap.this.rendererProviders.get(key);
            if (provider == null) {
                return Optional.empty();
            }
            Class<class_5619> clazz = class_5619.class;
            synchronized (class_5619.class) {
                ErroredEntityRenderer renderer;
                try {
                    renderer = provider.create(EntityRendererMap.this.context);
                    ModernFix.LOGGER.info("Loaded entity {}", (Object)class_7923.field_41177.method_10221(key));
                }
                catch (RuntimeException e) {
                    ModernFix.LOGGER.error("Failed to create entity model for " + String.valueOf(class_7923.field_41177.method_10221(key)) + ":", (Throwable)e);
                    renderer = new ErroredEntityRenderer(EntityRendererMap.this.context);
                }
                return Optional.ofNullable(renderer);
            }
        }
    }

    private class Entry
    implements Map.Entry<class_1299<?>, class_897<?>> {
        private final class_1299<?> key;

        private Entry(class_1299<?> key) {
            this.key = key;
        }

        @Override
        public class_1299<?> getKey() {
            return this.key;
        }

        @Override
        public class_897<?> getValue() {
            return EntityRendererMap.this.get(this.key);
        }

        @Override
        public class_897<?> setValue(class_897<?> value) {
            return EntityRendererMap.this.put(this.key, value);
        }
    }
}

