/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common;

import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common.ItemStackToListCache;
import dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common.WrappedLootCrate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;

public class WrappedLootCrateCache {
    private final List<WrappedLootCrate> wrappedLootCratesCache = new ArrayList<WrappedLootCrate>();
    private final ItemStackToListCache<WrappedLootCrate> inputCache = new ItemStackToListCache();
    private final ItemStackToListCache<WrappedLootCrate> outputCache = new ItemStackToListCache();
    private final List<class_1799> crateStacks = new ArrayList<class_1799>();
    private final Consumer<List<class_1799>> preRebuild;
    private final Consumer<List<class_1799>> postRebuild;
    private boolean needsRefresh = true;

    public WrappedLootCrateCache(Consumer<List<class_1799>> preRebuild, Consumer<List<class_1799>> postRebuild) {
        this.preRebuild = preRebuild;
        this.postRebuild = postRebuild;
    }

    public List<WrappedLootCrate> getWrappedLootCrates() {
        if (this.needsRefresh) {
            this.rebuildWrappedLootCrateCache();
            this.needsRefresh = false;
        }
        return this.wrappedLootCratesCache;
    }

    private void rebuildWrappedLootCrateCache() {
        this.preRebuild.accept(List.copyOf(this.crateStacks));
        this.wrappedLootCratesCache.clear();
        this.crateStacks.clear();
        if (ClientQuestFile.exists()) {
            for (RewardTable table : ClientQuestFile.INSTANCE.getRewardTables()) {
                if (table.getLootCrate() == null) continue;
                WrappedLootCrate wrapper = new WrappedLootCrate(table.getLootCrate());
                this.wrappedLootCratesCache.add(wrapper);
                this.crateStacks.add(table.getLootCrate().createStack());
            }
        }
        this.postRebuild.accept(List.copyOf(this.crateStacks));
    }

    public void refresh() {
        this.needsRefresh = true;
        this.outputCache.clear();
        this.inputCache.clear();
    }

    public List<WrappedLootCrate> findCratesWithOutput(class_1799 stack) {
        return this.outputCache.getList(stack, k -> this.getWrappedLootCrates().stream().filter(crate -> crate.outputs.stream().anyMatch(s1 -> s1.method_31574(stack.method_7909()))).toList());
    }

    public List<WrappedLootCrate> findCratesWithInput(class_1799 stack) {
        return this.inputCache.getList(stack, k -> this.getWrappedLootCrates().stream().filter(crate -> class_1799.method_31577((class_1799)crate.crateStack, (class_1799)stack)).toList());
    }

    public Collection<class_1799> knownCrateStacks() {
        return this.crateStacks;
    }
}

