/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1041;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_640;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.helper.DrawContext;
import nx.pingwheel.common.helper.InputUtils;
import nx.pingwheel.common.helper.LanguageUtils;
import nx.pingwheel.common.helper.MathUtils;
import nx.pingwheel.common.helper.Ping;
import nx.pingwheel.common.helper.Raycast;
import nx.pingwheel.common.helper.ScreenPos;
import nx.pingwheel.common.networking.PingLocationC2SPacket;
import nx.pingwheel.common.networking.PingLocationS2CPacket;
import nx.pingwheel.common.screen.SettingsScreen;
import nx.pingwheel.common.sound.DirectionalSoundInstance;
import org.joml.Matrix4f;

public class ClientCore {
    private static final ClientConfig Config = ClientGlobal.ConfigHandler.getConfig();
    private static final ArrayList<Ping> pingRepo = new ArrayList();
    private static boolean pingQueued = false;
    private static class_638 lastWorld = null;
    private static int dimension = 0;
    private static int lastPing = 0;
    private static int pingSequence = 0;

    private ClientCore() {
    }

    public static void onDisconnect() {
        pingRepo.clear();
    }

    public static void onTick() {
        ClientGlobal.Game = class_310.method_1551();
        if (InputUtils.consumePingHotkey()) {
            pingQueued = true;
        }
        if (ClientGlobal.KEY_BINDING_SETTINGS.method_1436()) {
            ClientGlobal.Game.method_1507((class_437)new SettingsScreen());
        }
    }

    public static void onPingLocation(PingLocationS2CPacket packet) {
        class_243 vecToPing;
        if (packet.isCorrupt()) {
            Global.LOGGER.warn("received invalid ping location from server");
            return;
        }
        class_634 connection = ClientGlobal.Game.method_1562();
        if (ClientGlobal.Game.field_1724 == null || ClientGlobal.Game.field_1687 == null || connection == null) {
            return;
        }
        if (!packet.channel().equals(Config.getChannel())) {
            return;
        }
        if (Config.getPingDistance() < 2048 && (vecToPing = ClientGlobal.Game.field_1724.method_19538().method_1035(packet.pos())).method_1033() > (double)Config.getPingDistance()) {
            return;
        }
        class_640 authorInfo = connection.method_2871(packet.author());
        ClientGlobal.Game.execute(() -> {
            ClientCore.addOrReplacePing(new Ping(packet.pos(), packet.entity(), authorInfo, packet.sequence(), packet.dimension(), (int)ClientGlobal.Game.field_1687.method_8510()));
            if (packet.dimension() == dimension) {
                ClientGlobal.Game.method_1483().method_4873((class_1113)new DirectionalSoundInstance(ClientGlobal.PING_SOUND_EVENT, class_3419.field_15250, (float)Config.getPingVolume() / 100.0f, 1.0f, packet.pos()));
            }
        });
    }

    public static void onRenderWorld(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float tickDelta) {
        if (ClientGlobal.Game.field_1687 == null) {
            return;
        }
        if (lastWorld != ClientGlobal.Game.field_1687) {
            lastWorld = ClientGlobal.Game.field_1687;
            dimension = lastWorld.method_27983().method_29177().hashCode();
        }
        int time = (int)ClientGlobal.Game.field_1687.method_8510();
        ClientCore.processPings(modelViewMatrix, projectionMatrix, tickDelta, time);
        if (pingQueued) {
            if (Config.getCorrectionPeriod() < 5.0f && (float)(time - lastPing) > Config.getCorrectionPeriod() * 20.0f) {
                ++pingSequence;
            }
            lastPing = time;
            pingQueued = false;
            ClientCore.executePing(tickDelta);
        }
    }

    public static void onRenderGUI(class_332 gg, float tickDelta) {
        if (ClientGlobal.Game.field_1724 == null || pingRepo.isEmpty()) {
            return;
        }
        class_4587 m = gg.method_51448();
        DrawContext ctx = new DrawContext(gg);
        class_1041 wnd = ClientGlobal.Game.method_22683();
        class_241 screenSize = new class_241((float)wnd.method_4486(), (float)wnd.method_4502());
        class_241 safeZoneTopLeft = new class_241((float)Config.getSafeZoneLeft(), (float)Config.getSafeZoneTop());
        class_241 safeZoneBottomRight = new class_241(screenSize.field_1343 - (float)Config.getSafeZoneRight(), screenSize.field_1342 - (float)Config.getSafeZoneBottom());
        class_241 safeScreenCenter = new class_241((safeZoneBottomRight.field_1343 - safeZoneTopLeft.field_1343) * 0.5f, (safeZoneBottomRight.field_1342 - safeZoneTopLeft.field_1342) * 0.5f);
        boolean showDirectionIndicator = Config.isDirectionIndicatorVisible();
        boolean showNameLabels = Config.isNameLabelForced() || ClientGlobal.KEY_BINDING_NAME_LABELS.method_1434();
        m.method_22903();
        m.method_46416(0.0f, 0.0f, (float)(-pingRepo.size()) * 16.0f);
        for (Ping ping : pingRepo) {
            boolean isOffScreen;
            ScreenPos screenPos = ping.getScreenPos();
            if (screenPos == null || ping.getDimension() != dimension || screenPos.isBehindCamera() && !showDirectionIndicator) continue;
            m.method_46416(0.0f, 0.0f, 16.0f);
            float pingSize = (float)Config.getPingSize() / 100.0f;
            float pingScale = ClientCore.getDistanceScale(ping.getDistance()) * pingSize * 0.4f;
            class_241 pingDirectionVec = new class_241(screenPos.x - safeZoneTopLeft.field_1343 - safeScreenCenter.field_1343, screenPos.y - safeZoneTopLeft.field_1342 - safeScreenCenter.field_1342);
            boolean behindCamera = screenPos.isBehindCamera();
            if (behindCamera) {
                pingDirectionVec = pingDirectionVec.method_35582(-1.0f);
            }
            float pingAngle = (float)Math.atan2(pingDirectionVec.field_1342, pingDirectionVec.field_1343);
            boolean bl = isOffScreen = behindCamera || !screenPos.isInBounds(class_241.field_1340, screenSize);
            if (isOffScreen && showDirectionIndicator) {
                class_241 indicator = MathUtils.calculateAngleRectIntersection(pingAngle, safeZoneTopLeft, safeZoneBottomRight);
                m.method_22903();
                m.method_46416(indicator.field_1343, indicator.field_1342, 0.0f);
                m.method_22903();
                m.method_22905(pingScale, pingScale, 1.0f);
                double indicatorOffsetX = Math.cos((double)pingAngle + Math.PI) * 12.0;
                double indicatorOffsetY = Math.sin((double)pingAngle + Math.PI) * 12.0;
                m.method_22904(indicatorOffsetX, indicatorOffsetY, 0.0);
                ctx.renderPing(ping.getItemStack(), Config.isItemIconVisible());
                m.method_22909();
                m.method_22903();
                MathUtils.rotateZ(m, pingAngle);
                m.method_22905(pingSize, pingSize, 1.0f);
                m.method_22905(0.25f, 0.25f, 1.0f);
                m.method_46416(-5.0f, 0.0f, 0.0f);
                ctx.renderArrowIcon();
                m.method_22909();
                m.method_22909();
            }
            if (behindCamera) continue;
            m.method_22903();
            m.method_46416(screenPos.x, screenPos.y, 0.0f);
            m.method_22905(pingScale, pingScale, 1.0f);
            class_5250 text = LanguageUtils.UNIT_METERS.get("%,.1f".formatted(ping.getDistance()));
            ctx.renderLabel((class_2561)text, -1.5f, null);
            ctx.renderPing(ping.getItemStack(), Config.isItemIconVisible());
            class_640 author = ping.getAuthor();
            if (showNameLabels && author != null) {
                class_5250 displayName = class_268.method_1142((class_270)author.method_2955(), (class_2561)class_2561.method_43470((String)author.method_2966().getName()));
                ctx.renderLabel((class_2561)displayName, 1.75f, author);
            }
            m.method_22909();
        }
        m.method_22909();
    }

    private static void processPings(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float tickDelta, int time) {
        if (ClientGlobal.Game.field_1724 == null || pingRepo.isEmpty()) {
            return;
        }
        class_243 cameraPos = ClientGlobal.Game.field_1724.method_5836(tickDelta);
        Ping target = null;
        Iterator<Ping> iter = pingRepo.iterator();
        while (iter.hasNext()) {
            class_1297 ent;
            Ping ping = iter.next();
            if (ping.getUuid() != null && (ent = ClientCore.getEntity(ping.getUuid())) != null) {
                if (ent.method_5864() == class_1299.field_6052 && Config.isItemIconVisible()) {
                    ping.setItemStack(((class_1542)ent).method_6983().method_7972());
                }
                ping.setPos(ent.method_30950(tickDelta).method_1031(0.0, ent.method_5829().method_17940(), 0.0));
            }
            ping.setDistance(cameraPos.method_1022(ping.getPos()));
            ping.setScreenPos(MathUtils.worldToScreen(ping.getPos(), modelViewMatrix, projectionMatrix));
            ping.setAge(time - ping.getSpawnTime());
            if (ping.isExpired()) {
                iter.remove();
                continue;
            }
            if (!pingQueued || !ping.isRemovable() || !ping.isCloserToCenter(target)) continue;
            target = ping;
        }
        if (target != null && pingRepo.remove(target)) {
            pingQueued = false;
        }
        pingRepo.sort((a, b) -> Double.compare(b.getDistance(), a.getDistance()));
    }

    private static void executePing(float tickDelta) {
        class_1297 cameraEntity = ClientGlobal.Game.field_1719;
        if (cameraEntity == null || ClientGlobal.Game.field_1687 == null) {
            return;
        }
        class_243 cameraDirection = cameraEntity.method_5828(tickDelta);
        class_239 hitResult = Raycast.traceDirectional(cameraDirection, tickDelta, Math.min(Config.getRaycastDistance(), Config.getPingDistance()), cameraEntity.method_18276());
        if (hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        UUID uuid = null;
        if (hitResult.method_17783() == class_239.class_240.field_1331) {
            uuid = ((class_3966)hitResult).method_17782().method_5667();
        }
        Global.NetHandler.sendToServer(new PingLocationC2SPacket(Config.getChannel(), hitResult.method_17784(), uuid, pingSequence, dimension));
    }

    private static void addOrReplacePing(Ping newPing) {
        int index = -1;
        for (int i = 0; i < pingRepo.size(); ++i) {
            Ping entry = pingRepo.get(i);
            if (!Objects.equals(entry.getAuthor(), newPing.getAuthor()) || entry.getSequence() != newPing.getSequence()) continue;
            index = i;
            break;
        }
        if (index != -1) {
            pingRepo.set(index, newPing);
        } else {
            pingRepo.add(newPing);
        }
    }

    private static class_1297 getEntity(UUID uuid) {
        if (ClientGlobal.Game.field_1687 == null) {
            return null;
        }
        for (class_1297 entity : ClientGlobal.Game.field_1687.method_18112()) {
            if (!entity.method_5667().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    private static float getDistanceScale(double distance) {
        double scale = 2.0 / Math.pow(distance, 0.3);
        return (float)Math.max(1.0, scale);
    }
}

