/*
 * Decompiled with CFR 0.152.
 */
package ru.nern.playerladder.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import ru.nern.playerladder.PlayerLadder;

public class ConfigurationManager {
    private static final String MOD_VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("playerladder").get()).getMetadata().getVersion().getFriendlyString();
    private static final File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "playerladder_config.json");
    public static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void loadConfig() {
        block11: {
            try {
                if (!file.exists()) break block11;
                StringBuilder contentBuilder = new StringBuilder();
                try (Stream<String> stream = Files.lines(file.toPath(), StandardCharsets.UTF_8);){
                    stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                PlayerLadder.CONFIG = (Config)gson.fromJson(contentBuilder.toString(), Config.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (PlayerLadder.CONFIG == null) {
            PlayerLadder.CONFIG = new Config();
        }
    }

    public static void saveConfig() {
        PlayerLadder.CONFIG.lastLoadedVersion = MOD_VERSION;
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)PlayerLadder.CONFIG));
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onInit() {
        if (!file.exists()) {
            ConfigurationManager.saveConfig();
        } else {
            ConfigurationManager.loadConfig();
            if (!Objects.equals(PlayerLadder.CONFIG.lastLoadedVersion, MOD_VERSION)) {
                ConfigurationManager.saveConfig();
            }
        }
    }

    public static class Config {
        public String lastLoadedVersion = "";
        public Server server = new Server();
        public Client client = new Client();

        public static class Server {
            public ClickMode mode = ClickMode.RIDE;
            public int pickUpLimit = 16;
            public int stepUpLimit = 16;
            public boolean interactWithAnyLiving = false;
            public boolean rideExtension = true;
        }

        public static class Client {
            public boolean allowInteractions = true;
        }
    }

    public static enum ClickMode {
        RIDE,
        PICK_UP,
        DO_NOTHING;

    }
}

