/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.level.block.entity;

import fuzs.linkedchests.LinkedChests;
import fuzs.linkedchests.network.UpdateLidControllerMessage;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import fuzs.puzzleslib.api.container.v1.ListBackedContainer;
import fuzs.puzzleslib.api.network.v3.ClientboundMessage;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class LinkedChestOpenersCounter {
    private final Predicate<class_2371<class_1799>> containerChecker;
    private int openCount;
    private boolean scheduleRecheck;

    public LinkedChestOpenersCounter(Predicate<class_2371<class_1799>> containerChecker) {
        this.containerChecker = containerChecker;
    }

    protected void openerCountChanged(DyeChannel dyeChannel, MinecraftServer server, int openCount) {
        LinkedChests.NETWORK.sendMessage(PlayerSet.ofAll((MinecraftServer)server), (ClientboundMessage)new UpdateLidControllerMessage(dyeChannel, openCount > 0));
    }

    protected boolean isOwnContainer(class_1657 player) {
        ListBackedContainer container;
        class_1707 chestMenu;
        class_1703 class_17032 = player.field_7512;
        return class_17032 instanceof class_1707 && (class_17032 = (chestMenu = (class_1707)class_17032).method_7629()) instanceof ListBackedContainer && this.containerChecker.test((class_2371<class_1799>)(container = (ListBackedContainer)class_17032).getContainerItems());
    }

    public void incrementOpeners(DyeChannel dyeChannel, class_3222 serverPlayer) {
        this.incrementOpeners(dyeChannel, serverPlayer, serverPlayer.method_24515(), serverPlayer.method_5634());
    }

    public void incrementOpeners(DyeChannel dyeChannel, class_3222 serverPlayer, class_2338 pos, class_3419 soundSource) {
        class_3218 serverLevel = serverPlayer.method_51469();
        if (this.openCount++ == 0) {
            serverLevel.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14952, soundSource, 0.5f, serverLevel.field_9229.method_43057() * 0.1f + 0.9f);
            serverLevel.method_33596((class_1297)serverPlayer, (class_6880)class_5712.field_28176, pos);
            this.scheduleRecheck = true;
        }
        this.openerCountChanged(dyeChannel, serverLevel.method_8503(), this.openCount);
    }

    public void decrementOpeners(DyeChannel dyeChannel, class_3222 serverPlayer) {
        this.decrementOpeners(dyeChannel, serverPlayer, serverPlayer.method_24515(), serverPlayer.method_5634());
    }

    public void decrementOpeners(DyeChannel dyeChannel, class_3222 serverPlayer, class_2338 pos, class_3419 soundSource) {
        class_3218 serverLevel = serverPlayer.method_51469();
        if (--this.openCount == 0) {
            serverLevel.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_15206, soundSource, 0.5f, serverLevel.field_9229.method_43057() * 0.1f + 0.9f);
            serverLevel.method_33596((class_1297)serverPlayer, (class_6880)class_5712.field_28177, pos);
        }
        this.openerCountChanged(dyeChannel, serverLevel.method_8503(), this.openCount);
    }

    public void recheckOpeners(DyeChannel dyeChannel, MinecraftServer server) {
        if (this.scheduleRecheck) {
            this.scheduleRecheck = false;
            int playersWithContainerOpen = this.getPlayersWithContainerOpen(server).size();
            if (this.openCount != playersWithContainerOpen) {
                this.openCount = playersWithContainerOpen;
                this.openerCountChanged(dyeChannel, server, playersWithContainerOpen);
            }
            if (this.openCount > 0) {
                this.scheduleRecheck = true;
            }
        }
    }

    private List<? extends class_1657> getPlayersWithContainerOpen(MinecraftServer server) {
        return server.method_3760().method_14571().stream().filter(this::isOwnContainer).toList();
    }
}

