/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.level.block.entity;

import com.mojang.serialization.DynamicOps;
import fuzs.linkedchests.LinkedChests;
import fuzs.linkedchests.client.handler.DyeChannelLidController;
import fuzs.linkedchests.init.ModRegistry;
import fuzs.linkedchests.world.inventory.LinkedMenu;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import fuzs.linkedchests.world.level.block.entity.DyeChannelManager;
import fuzs.linkedchests.world.level.block.entity.DyeChannelStorage;
import fuzs.puzzleslib.api.container.v1.ListBackedContainer;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2618;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LinkedChestBlockEntity
extends class_2586
implements ListBackedContainer,
class_3908,
class_2618 {
    static final String KEY_DYE_CHANNEL = LinkedChests.id("dye_channel").toString();
    static final String KEY_LATCH_ITEM = LinkedChests.id("latch_item").toString();
    private DyeChannel dyeChannel = DyeChannel.DEFAULT;
    private class_1799 latchItem = class_1799.field_8037;
    @Nullable
    private DyeChannelStorage storage;

    public LinkedChestBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModRegistry.LINKED_CHEST_BLOCK_ENTITY.comp_349(), pos, state);
    }

    public void method_11014(class_2487 compoundTag, class_7225.class_7874 registries) {
        super.method_11014(compoundTag, registries);
        this.dyeChannel = DyeChannel.CODEC.parse((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)compoundTag.method_10562(KEY_DYE_CHANNEL)).resultOrPartial(arg_0 -> ((Logger)LinkedChests.LOGGER).error(arg_0)).orElse(DyeChannel.DEFAULT);
        this.latchItem = class_1799.method_57359((class_7225.class_7874)registries, (class_2487)compoundTag.method_10562(KEY_LATCH_ITEM));
    }

    public void method_11007(class_2487 compoundTag, class_7225.class_7874 registries) {
        super.method_11007(compoundTag, registries);
        DyeChannel.CODEC.encodeStart((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)this.dyeChannel).resultOrPartial(arg_0 -> ((Logger)LinkedChests.LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.method_10566(KEY_DYE_CHANNEL, tag));
        if (!this.latchItem.method_7960()) {
            compoundTag.method_10566(KEY_LATCH_ITEM, this.latchItem.method_57358(registries));
        }
    }

    public DyeChannel getDyeChannel() {
        return this.dyeChannel;
    }

    public void setDyeChannel(DyeChannel dyeChannel) {
        Objects.requireNonNull(dyeChannel, "dye channel is null");
        if (!Objects.equals(dyeChannel, this.dyeChannel)) {
            this.dyeChannel = dyeChannel;
            this.storage = null;
            this.markUpdated();
        }
    }

    public void setLatchItem(class_1799 itemStack) {
        this.latchItem = itemStack;
        this.method_5431();
    }

    public class_1799 removeLatchItem() {
        class_1799 itemStack = this.latchItem;
        this.latchItem = class_1799.field_8037;
        this.method_5431();
        return itemStack;
    }

    private DyeChannelStorage getStorage() {
        DyeChannelStorage storage = this.storage;
        if (storage == null) {
            this.storage = DyeChannelManager.getStorage(this.dyeChannel);
            return this.storage;
        }
        return storage;
    }

    private void markUpdated() {
        this.method_5431();
        if (this.method_11002()) {
            this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    public void method_5435(class_1657 player) {
        if (!this.field_11865 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (!player.method_7325()) {
                this.getStorage().openersCounter().incrementOpeners(this.dyeChannel, serverPlayer, this.method_11016(), class_3419.field_15245);
            }
        }
    }

    public void method_5432(class_1657 player) {
        if (!this.field_11865 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (!player.method_7325()) {
                this.getStorage().openersCounter().decrementOpeners(this.dyeChannel, serverPlayer, this.method_11016(), class_3419.field_15245);
            }
        }
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public float method_11274(float partialTicks) {
        if (this.method_11002() && this.method_10997().field_9236) {
            return DyeChannelLidController.getChestLidController(this.dyeChannel).method_31673(partialTicks);
        }
        return 0.0f;
    }

    public class_2371<class_1799> getContainerItems() {
        return this.getStorage().items();
    }

    public class_2561 method_5476() {
        return ((class_2248)ModRegistry.LINKED_CHEST_BLOCK.comp_349()).method_9518();
    }

    public class_1703 createMenu(int containerId, class_1661 inventory, class_1657 player) {
        return new LinkedMenu(containerId, inventory, (class_1263)this, this.dyeChannel.uuid().isPresent(), false);
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        super.method_57568(componentInput);
        this.dyeChannel = (DyeChannel)componentInput.method_58694((class_9331)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.comp_349());
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        components.method_57840((class_9331)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.comp_349(), (Object)this.dyeChannel);
    }

    public void method_57569(class_2487 tag) {
        tag.method_10551(KEY_DYE_CHANNEL);
    }
}

