/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.level.block.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import fuzs.linkedchests.LinkedChests;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import fuzs.linkedchests.world.level.block.entity.DyeChannelStorage;
import fuzs.puzzleslib.api.event.v1.server.ServerLifecycleEvents;
import fuzs.puzzleslib.api.event.v1.server.ServerTickEvents;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_7225;
import org.slf4j.Logger;

public final class DyeChannelManager
extends class_18 {
    static final String KEY_CHANNELS = LinkedChests.id("channels").toString();
    public static final Codec<Map<DyeChannel, DyeChannelStorage>> CODEC = Codec.mapPair((MapCodec)DyeChannel.CODEC.fieldOf("dye_channel"), (MapCodec)DyeChannelStorage.CODEC.fieldOf("storage")).codec().listOf().xmap(list -> (Map)list.stream().collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond)), map -> map.entrySet().stream().map(entry -> new Pair((Object)((DyeChannel)entry.getKey()), (Object)((DyeChannelStorage)entry.getValue()))).toList());
    private static DyeChannelManager instance;
    private final Map<DyeChannel, DyeChannelStorage> channels;

    private DyeChannelManager() {
        this.channels = new HashMap<DyeChannel, DyeChannelStorage>();
    }

    private DyeChannelManager(Map<DyeChannel, DyeChannelStorage> channels) {
        this.channels = new HashMap<DyeChannel, DyeChannelStorage>(channels);
    }

    private static class_18.class_8645<DyeChannelManager> factory() {
        return new class_18.class_8645(DyeChannelManager::new, DyeChannelManager::load, null);
    }

    private static DyeChannelManager load(class_2487 compoundTag, class_7225.class_7874 registries) {
        return CODEC.parse((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)compoundTag.method_10554(KEY_CHANNELS, 10)).resultOrPartial(arg_0 -> ((Logger)LinkedChests.LOGGER).error(arg_0)).map(DyeChannelManager::new).orElseGet(DyeChannelManager::new);
    }

    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 registries) {
        CODEC.encodeStart((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), this.channels).resultOrPartial(arg_0 -> ((Logger)LinkedChests.LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.method_10566(KEY_CHANNELS, tag));
        return compoundTag;
    }

    public static void registerEventHandlers() {
        ServerLifecycleEvents.STARTED.register(server -> {
            instance = (DyeChannelManager)server.method_30002().method_17983().method_17924(DyeChannelManager.factory(), "linkedchests");
        });
        ServerLifecycleEvents.STOPPED.register(server -> {
            instance = null;
        });
        ServerTickEvents.END.register(server -> {
            DyeChannelManager channelManager;
            if (server.method_3780() % 20 == 0 && (channelManager = instance) != null) {
                channelManager.channels.forEach((dyeChannel, storage) -> storage.openersCounter().recheckOpeners((DyeChannel)dyeChannel, server));
            }
        });
    }

    public static DyeChannelStorage getStorage(DyeChannel dyeChannel) {
        DyeChannelManager channelManager = instance;
        if (channelManager != null) {
            return channelManager.channels.computeIfAbsent(dyeChannel, DyeChannel::createStorage);
        }
        return new DyeChannelStorage(3);
    }

    public boolean method_79() {
        return true;
    }
}

