/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.level.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.linkedchests.LinkedChests;
import fuzs.linkedchests.config.ServerConfig;
import fuzs.linkedchests.world.level.block.entity.DyeChannelStorage;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_4844;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public record DyeChannel(class_1767 leftColor, class_1767 middleColor, class_1767 rightColor, Optional<UUID> uuid) {
    public static final DyeChannel DEFAULT = new DyeChannel(class_1767.field_7952);
    public static final Codec<DyeChannel> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1767.field_41600.listOf().validate(list -> class_156.method_33141((List)list, (int)3)).fieldOf("colors").forGetter(dyeChannel -> List.of(dyeChannel.leftColor, dyeChannel.middleColor, dyeChannel.rightColor)), (App)class_4844.field_25122.optionalFieldOf("uuid").forGetter(DyeChannel::uuid)).apply((Applicative)instance, (colors, uuid) -> new DyeChannel((class_1767)colors.get(0), (class_1767)colors.get(1), (class_1767)colors.get(2), (Optional<UUID>)uuid)));
    public static final class_9139<ByteBuf, DyeChannel> STREAM_CODEC = class_9139.method_56905((class_9139)class_1767.field_49259, DyeChannel::leftColor, (class_9139)class_1767.field_49259, DyeChannel::middleColor, (class_9139)class_1767.field_49259, DyeChannel::rightColor, (class_9139)class_4844.field_48453.method_56433(class_9135::method_56382), DyeChannel::uuid, DyeChannel::new);

    public DyeChannel(class_1767 dyeColor) {
        this(dyeColor, dyeColor, dyeColor, Optional.empty());
    }

    public DyeChannel withColorAt(int index, class_1767 dyeColor) {
        return switch (index) {
            case 0 -> this.withLeftColor(dyeColor);
            case 1 -> this.withMiddleColor(dyeColor);
            case 2 -> this.withRightColor(dyeColor);
            default -> throw new RuntimeException();
        };
    }

    public DyeChannel withLeftColor(class_1767 leftColor) {
        if (leftColor != this.leftColor) {
            return new DyeChannel(leftColor, this.middleColor, this.rightColor, this.uuid);
        }
        return this;
    }

    public DyeChannel withMiddleColor(class_1767 middleColor) {
        if (middleColor != this.middleColor) {
            return new DyeChannel(this.leftColor, middleColor, this.rightColor, this.uuid);
        }
        return this;
    }

    public DyeChannel withRightColor(class_1767 rightColor) {
        if (rightColor != this.rightColor) {
            return new DyeChannel(this.leftColor, this.middleColor, rightColor, this.uuid);
        }
        return this;
    }

    public DyeChannel withUUID(@Nullable UUID uuid) {
        return new DyeChannel(this.leftColor, this.middleColor, this.rightColor, Optional.ofNullable(uuid));
    }

    public DyeChannelStorage createStorage() {
        return new DyeChannelStorage(DyeChannel.getContainerSize(this.uuid.isPresent()));
    }

    public static int getContainerSize(boolean personalChannel) {
        int inventoryRows = personalChannel ? ((ServerConfig)LinkedChests.CONFIG.get(ServerConfig.class)).personalInventoryRows : ((ServerConfig)LinkedChests.CONFIG.get(ServerConfig.class)).inventoryRows;
        return inventoryRows * 9;
    }

    public static class_1767 getDyeColor(class_1792 item) {
        class_1767 class_17672;
        if (item instanceof class_1769) {
            class_1769 dyeItem = (class_1769)item;
            class_17672 = dyeItem.method_7802();
        } else {
            class_17672 = class_1767.field_7952;
        }
        return class_17672;
    }
}

