/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import fuzs.linkedchests.init.ModRegistry;
import fuzs.linkedchests.world.level.block.HighlightShapeProvider;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import fuzs.linkedchests.world.level.block.entity.LinkedChestBlockEntity;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.shape.v1.ShapesHelper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2336;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4838;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9062;
import net.minecraft.class_9331;

public class LinkedChestBlock
extends class_2336
implements HighlightShapeProvider {
    public static final MapCodec<class_2336> CODEC = LinkedChestBlock.method_54094(LinkedChestBlock::new);
    static final class_265 LEFT_BUTTON_SHAPE = class_2248.method_9541((double)4.0, (double)14.0, (double)6.0, (double)6.0, (double)15.0, (double)10.0);
    static final Map<class_2350, class_265> LEFT_BUTTON_SHAPES = ShapesHelper.rotateHorizontally((class_265)LEFT_BUTTON_SHAPE);
    static final class_265 MIDDLE_BUTTON_SHAPE = class_2248.method_9541((double)7.0, (double)14.0, (double)6.0, (double)9.0, (double)15.0, (double)10.0);
    static final Map<class_2350, class_265> MIDDLE_BUTTON_SHAPES = ShapesHelper.rotateHorizontally((class_265)MIDDLE_BUTTON_SHAPE);
    static final class_265 RIGHT_BUTTON_SHAPE = class_2248.method_9541((double)10.0, (double)14.0, (double)6.0, (double)12.0, (double)15.0, (double)10.0);
    static final Map<class_2350, class_265> RIGHT_BUTTON_SHAPES = ShapesHelper.rotateHorizontally((class_265)RIGHT_BUTTON_SHAPE);
    static final class_265 LATCH_SHAPE = class_2248.method_9541((double)7.0, (double)7.0, (double)15.0, (double)9.0, (double)11.0, (double)16.0);
    static final Map<class_2350, class_265> LATCH_SHAPES = ShapesHelper.rotateHorizontally((class_265)LATCH_SHAPE);
    static final Map<class_2350, class_265> SHAPES = (Map)class_2350.class_2353.field_11062.method_29716().collect(Maps.toImmutableEnumMap(Function.identity(), direction -> class_259.method_17786((class_265)class_2336.field_10967, (class_265[])new class_265[]{LEFT_BUTTON_SHAPES.get(direction), MIDDLE_BUTTON_SHAPES.get(direction), RIGHT_BUTTON_SHAPES.get(direction), LATCH_SHAPES.get(direction)})));

    public LinkedChestBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public MapCodec<class_2336> method_53969() {
        return CODEC;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPES.get(state.method_11654((class_2769)field_10966));
    }

    protected class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return class_2336.field_10967;
    }

    @Override
    public class_265 getHighlightShape(class_2680 state, class_1922 level, class_2338 pos, class_243 hitVector) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_10966);
        hitVector = hitVector.method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        List<Map<class_2350, class_265>> shapes = List.of(LEFT_BUTTON_SHAPES, MIDDLE_BUTTON_SHAPES, RIGHT_BUTTON_SHAPES, LATCH_SHAPES);
        for (Map<class_2350, class_265> map : shapes) {
            class_265 voxelShape = map.get(direction);
            if (!voxelShape.method_1107().method_1014(0.001).method_1006(hitVector)) continue;
            return voxelShape;
        }
        return class_2336.field_10967;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        return class_1269.field_5811;
    }

    protected class_9062 method_55765(class_1799 itemInHand, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_3908 menuProvider;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof LinkedChestBlockEntity) {
            LinkedChestBlockEntity blockEntity = (LinkedChestBlockEntity)class_25862;
            DyeChannel dyeChannel = blockEntity.getDyeChannel();
            class_2350 direction = (class_2350)state.method_11654((class_2769)field_10966);
            class_243 hitVector = hitResult.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            if (itemInHand.method_31573(ModRegistry.DYE_CHANNEL_COLOR_PROVIDERS_ITEM_TAG)) {
                class_1767 dyeColor = DyeChannel.getDyeColor(itemInHand.method_7909());
                DyeChannel newDyeChannel = dyeChannel;
                if (LEFT_BUTTON_SHAPES.get(direction).method_1107().method_1014(0.001).method_1006(hitVector)) {
                    newDyeChannel = dyeChannel.withLeftColor(dyeColor);
                } else if (MIDDLE_BUTTON_SHAPES.get(direction).method_1107().method_1014(0.001).method_1006(hitVector)) {
                    newDyeChannel = dyeChannel.withMiddleColor(dyeColor);
                } else if (RIGHT_BUTTON_SHAPES.get(direction).method_1107().method_1014(0.001).method_1006(hitVector)) {
                    newDyeChannel = dyeChannel.withRightColor(dyeColor);
                }
                if (dyeChannel != newDyeChannel) {
                    if (!level.field_9236) {
                        blockEntity.setDyeChannel(newDyeChannel);
                        level.method_8396(null, pos, class_3417.field_40970, class_3419.field_15245, 1.0f, 1.0f);
                        itemInHand.method_57008(1, (class_1309)player);
                        level.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
                    }
                    return class_9062.method_55644((boolean)level.field_9236);
                }
            } else if (LATCH_SHAPES.get(direction).method_1107().method_1014(0.001).method_1006(hitVector)) {
                if (dyeChannel.uuid().isPresent()) {
                    if (itemInHand.method_7960() && player.method_5715()) {
                        if (!level.field_9236) {
                            blockEntity.setDyeChannel(dyeChannel.withUUID(null));
                            level.method_8396(null, pos, class_3417.field_14770, class_3419.field_15245, 1.0f, 1.0f);
                            class_1799 itemStack = blockEntity.removeLatchItem();
                            if (!player.method_31548().method_7394(itemStack)) {
                                player.method_7328(itemStack, false);
                            }
                            level.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
                        }
                        return class_9062.method_55644((boolean)level.field_9236);
                    }
                } else if (itemInHand.method_31573(ModRegistry.PERSONAL_CHANNEL_PROVIDERS_ITEM_TAG)) {
                    if (!level.field_9236) {
                        blockEntity.setDyeChannel(dyeChannel.withUUID(player.method_5667()));
                        level.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 1.0f, 1.0f);
                        blockEntity.setLatchItem(itemInHand.method_46651(1));
                        itemInHand.method_57008(1, (class_1309)player);
                        level.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
                    }
                    return class_9062.method_55644((boolean)level.field_9236);
                }
            }
        }
        if (!level.method_8320(pos.method_10084()).method_26212((class_1922)level, pos.method_10084()) && !level.field_9236 && (menuProvider = this.method_17454(state, level, pos)) != null) {
            player.method_17355(menuProvider);
            class_4838.method_24733((class_1657)player, (boolean)true);
        }
        return class_9062.method_55644((boolean)level.field_9236);
    }

    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 blockState) {
        class_1799 itemStack = super.method_9574(level, pos, blockState);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof LinkedChestBlockEntity) {
            LinkedChestBlockEntity blockEntity = (LinkedChestBlockEntity)class_25862;
            itemStack.method_57379((class_9331)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.comp_349(), (Object)blockEntity.getDyeChannel());
        }
        return itemStack;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return class_1703.method_7608((class_2586)level.method_8321(pos));
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        tooltipComponents.addAll(Proxy.INSTANCE.splitTooltipLines(this.getDescriptionComponent()));
    }

    public class_2561 getDescriptionComponent() {
        return class_2561.method_43471((String)(this.method_9539() + ".description")).method_27692(class_124.field_1065);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LinkedChestBlockEntity(pos, state);
    }
}

