/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.item.crafting;

import fuzs.linkedchests.init.ModRegistry;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9331;
import net.minecraft.class_9694;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class DyeChannelRecipe
extends class_1852 {
    public DyeChannelRecipe(class_7710 category) {
        super(category);
    }

    public boolean matches(class_9694 craftingInput, class_1937 level) {
        PositionedItem positionedItem = this.getDyeChannelItem(craftingInput);
        if (positionedItem != null) {
            DyeChannel dyeChannel = (DyeChannel)positionedItem.itemStack().method_57825((class_9331)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.comp_349(), (Object)DyeChannel.DEFAULT);
            MutableBoolean mutableBoolean = new MutableBoolean();
            List<PositionedItem> items = this.iterateDyeItems(craftingInput, positionedItem.posX(), positionedItem.posY(), (dyeColor, value) -> {
                if (dyeChannel.withColorAt(value, (class_1767)dyeColor) != dyeChannel) {
                    mutableBoolean.setTrue();
                }
            });
            if (mutableBoolean.isTrue()) {
                items.add(positionedItem);
                IntSet set = (IntSet)items.stream().map(item -> item.index(craftingInput.method_59991())).collect(Collectors.toCollection(IntArraySet::new));
                for (int i = 0; i < craftingInput.method_59983(); ++i) {
                    if (set.contains(i) || craftingInput.method_59984(i).method_7960()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Nullable
    private PositionedItem getDyeChannelItem(class_9694 craftingInput) {
        for (int width = 0; width < craftingInput.method_59991(); ++width) {
            for (int height = 0; height < craftingInput.method_59992(); ++height) {
                class_1799 itemStack = craftingInput.method_59985(width, height);
                if (!itemStack.method_57826((class_9331)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.comp_349())) continue;
                return new PositionedItem(itemStack, width, height);
            }
        }
        return null;
    }

    private List<PositionedItem> iterateDyeItems(class_9694 craftingInput, int posX, int posY, ObjIntConsumer<class_1767> consumer) {
        ArrayList<PositionedItem> dyeItems = new ArrayList<PositionedItem>();
        --posX;
        --posY;
        int i = 0;
        while (i < 3) {
            class_1799 itemStack;
            if (posX >= 0 && posX < craftingInput.method_59991() && posY >= 0 && posY < craftingInput.method_59992() && (itemStack = craftingInput.method_59985(posX, posY)).method_31573(ModRegistry.DYE_CHANNEL_COLOR_PROVIDERS_ITEM_TAG)) {
                consumer.accept(DyeChannel.getDyeColor(itemStack.method_7909()), i);
                dyeItems.add(new PositionedItem(itemStack, posX, posY));
            }
            ++i;
            ++posX;
        }
        return dyeItems;
    }

    public class_1799 assemble(class_9694 craftingInput, class_7225.class_7874 registries) {
        PositionedItem positionedItem = this.getDyeChannelItem(craftingInput);
        if (positionedItem != null) {
            class_1799 itemStack = positionedItem.itemStack().method_7972();
            this.iterateDyeItems(craftingInput, positionedItem.posX(), positionedItem.posY(), (dyeColor, value) -> {
                DyeChannel dyeChannel = (DyeChannel)itemStack.method_57825((class_9331)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.comp_349(), (Object)DyeChannel.DEFAULT);
                itemStack.method_57379((class_9331)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.comp_349(), (Object)dyeChannel.withColorAt(value, (class_1767)dyeColor));
            });
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return height >= 2;
    }

    public class_1865<?> method_8119() {
        return (class_1865)ModRegistry.DYE_CHANNEL_RECIPE_SERIALIZER.comp_349();
    }

    record PositionedItem(class_1799 itemStack, int posX, int posY) {
        public int index(int width) {
            return this.posX + this.posY * width;
        }
    }
}

