/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class InventorySorter {
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_NAME = Comparator.comparing(o -> ((ItemStackKey)o.getKey()).getStack().method_7964().getString().toLowerCase());
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_MOD = Comparator.comparing(o -> {
        class_2960 registryName = class_7923.field_41178.method_10221((Object)((ItemStackKey)o.getKey()).getStack().method_7909());
        return registryName.method_12836();
    }).thenComparing(o -> ((ItemStackKey)o.getKey()).getStack().method_7964().getString());
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_COUNT = (first, second) -> {
        int ret = ((Integer)second.getValue()).compareTo((Integer)first.getValue());
        return ret != 0 ? ret : InventorySorter.getRegistryName((ItemStackKey)first.getKey()).compareTo(InventorySorter.getRegistryName((ItemStackKey)second.getKey()));
    };
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_TAGS = new Comparator<Map.Entry<ItemStackKey, Integer>>(){

        @Override
        public int compare(Map.Entry<ItemStackKey, Integer> first, Map.Entry<ItemStackKey, Integer> second) {
            class_1799 secondStack;
            class_1792 secondItem;
            class_1799 firstStack = first.getKey().getStack();
            class_1792 firstItem = firstStack.method_7909();
            if (firstItem == (secondItem = (secondStack = second.getKey().getStack()).method_7909())) {
                return 0;
            }
            int ret = this.compareTags(firstStack.method_40133().collect(Collectors.toSet()), secondStack.method_40133().collect(Collectors.toSet()));
            return ret != 0 ? ret : InventorySorter.getRegistryName(first.getKey()).compareTo(InventorySorter.getRegistryName(second.getKey()));
        }

        private int compareTags(Set<class_6862<class_1792>> firstTags, Set<class_6862<class_1792>> secondTags) {
            int ret = Integer.compare(secondTags.size(), firstTags.size());
            if (ret != 0) {
                return ret;
            }
            if (firstTags.size() == 1) {
                return firstTags.iterator().next().comp_327().method_12833(secondTags.iterator().next().comp_327());
            }
            ArrayList<class_6862<class_1792>> firstTagsSorted = new ArrayList<class_6862<class_1792>>(firstTags);
            ArrayList<class_6862<class_1792>> secondTagsSorted = new ArrayList<class_6862<class_1792>>(secondTags);
            firstTagsSorted.sort(Comparator.comparing(class_6862::comp_327));
            secondTagsSorted.sort(Comparator.comparing(class_6862::comp_327));
            for (int i = 0; i < firstTagsSorted.size(); ++i) {
                ret = firstTagsSorted.get(i).comp_327().method_12833(secondTagsSorted.get(i).comp_327());
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
    };

    private InventorySorter() {
    }

    private static String getRegistryName(ItemStackKey itemStackKey) {
        return class_7923.field_41178.method_10221((Object)itemStackKey.getStack().method_7909()).toString();
    }

    public static void sortHandler(IItemHandlerSimpleInserter handler, Comparator<? super Map.Entry<ItemStackKey, Integer>> comparator, Set<Integer> noSortSlots) {
        Map<ItemStackKey, Integer> compactedStacks = InventoryHelper.getCompactedStacks(handler, noSortSlots, false);
        ArrayList<Map.Entry<ItemStackKey, Integer>> sortedList = new ArrayList<Map.Entry<ItemStackKey, Integer>>(compactedStacks.entrySet());
        sortedList.sort(comparator);
        int slots = handler.getSlotCount();
        InventorySorter.sortIntoNoSortSlots(handler, noSortSlots, sortedList);
        InventorySorter.sortIntoOtherSlots(handler, noSortSlots, sortedList, slots);
    }

    private static void sortIntoOtherSlots(IItemHandlerSimpleInserter handler, Set<Integer> noSortSlots, List<Map.Entry<ItemStackKey, Integer>> sortedList, int slots) {
        Iterator<Map.Entry<ItemStackKey, Integer>> ite = sortedList.iterator();
        ItemStackKey current = null;
        int count = 0;
        for (int slot = 0; slot < slots; ++slot) {
            if (noSortSlots.contains(slot)) continue;
            if ((current == null || count <= 0) && ite.hasNext()) {
                Map.Entry<ItemStackKey, Integer> entry = ite.next();
                current = entry.getKey();
                count = entry.getValue();
            }
            if (current != null && count > 0) {
                count -= InventorySorter.placeStack(handler, current, count, slot, false);
                continue;
            }
            InventorySorter.emptySlot(handler, slot);
        }
    }

    private static void sortIntoNoSortSlots(IItemHandlerSimpleInserter handler, Set<Integer> noSortSlots, List<Map.Entry<ItemStackKey, Integer>> sortedList) {
        Iterator<Map.Entry<ItemStackKey, Integer>> it = sortedList.iterator();
        if (!noSortSlots.isEmpty()) {
            block0: while (it.hasNext()) {
                Map.Entry<ItemStackKey, Integer> entry = it.next();
                ItemStackKey current = entry.getKey();
                Integer count = entry.getValue();
                for (int slot : noSortSlots) {
                    class_1799 slotStack = handler.getStackInSlot(slot);
                    if (!class_1799.method_31577((class_1799)slotStack, (class_1799)current.getStack())) continue;
                    int placedCount = InventorySorter.placeStack(handler, current, count, slot, true);
                    count = count - placedCount;
                    entry.setValue(count);
                    if (count > 0) continue;
                    it.remove();
                    continue block0;
                }
            }
        }
    }

    private static void emptySlot(IItemHandlerSimpleInserter handler, int slot) {
        if (!handler.getStackInSlot(slot).method_7960()) {
            if (handler instanceof InventoryHandler) {
                InventoryHandler inventoryHandler = (InventoryHandler)handler;
                inventoryHandler.setSlotStack(slot, class_1799.field_8037);
            } else {
                handler.setStackInSlot(slot, class_1799.field_8037);
            }
        }
    }

    private static int placeStack(IItemHandlerSimpleInserter handler, ItemStackKey current, int count, int slot, boolean countWithCurrentStack) {
        if (handler instanceof InventoryHandler) {
            InventoryHandler inventoryHandler = (InventoryHandler)handler;
            return InventorySorter.placeStack(current, count, slot, countWithCurrentStack, inventoryHandler::getStackLimit, inventoryHandler::getSlotStack, inventoryHandler::setSlotStack);
        }
        return InventorySorter.placeStack(current, count, slot, countWithCurrentStack, (s, stack) -> handler.getSlotLimit(s), arg_0 -> ((IItemHandlerSimpleInserter)handler).getStackInSlot(arg_0), (arg_0, arg_1) -> ((IItemHandlerSimpleInserter)handler).setStackInSlot(arg_0, arg_1));
    }

    private static int placeStack(ItemStackKey current, int count, int slot, boolean countWithCurrentStack, IStackLimitGetter stackLimitGetter, ISlotStackGetter slotStackGetter, ISlotStackSetter slotStackSetter) {
        class_1799 copy = current.getStack().method_7972();
        int slotLimit = stackLimitGetter.getStackLimit(slot, copy);
        int existingCount = slotStackGetter.getSlotStack(slot).method_7947();
        if (countWithCurrentStack) {
            count += existingCount;
        }
        int countPlaced = Math.min(count, slotLimit);
        copy.method_7939(countPlaced);
        if (!class_1799.method_7973((class_1799)slotStackGetter.getSlotStack(slot), (class_1799)copy)) {
            slotStackSetter.setSlotStack(slot, copy);
        }
        return countWithCurrentStack ? countPlaced - existingCount : countPlaced;
    }

    private static interface IStackLimitGetter {
        public int getStackLimit(int var1, class_1799 var2);
    }

    private static interface ISlotStackGetter {
        public class_1799 getSlotStack(int var1);
    }

    private static interface ISlotStackSetter {
        public void setSlotStack(int var1, class_1799 var2);
    }
}

