/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.controller;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public interface IControllerBoundable {
    public static final String CONTROLLER_POS_TAG = "controllerPos";

    public void setControllerPos(class_2338 var1);

    public Optional<class_2338> getControllerPos();

    public void removeControllerPos();

    public class_2338 getStorageBlockPos();

    public class_1937 getStorageBlockLevel();

    default public boolean canBeConnected() {
        return this.getControllerPos().isEmpty();
    }

    public void registerController(ControllerBlockEntityBase var1);

    public void unregisterController();

    public boolean canConnectStorages();

    default public void runOnController(class_1937 level, Consumer<ControllerBlockEntityBase> toRun) {
        this.getControllerPos().flatMap(pos -> WorldHelper.getLoadedBlockEntity(level, pos, ControllerBlockEntityBase.class)).ifPresent(toRun);
    }

    default public void saveControllerPos(class_2487 tag) {
        this.getControllerPos().ifPresent(p -> tag.method_10544(CONTROLLER_POS_TAG, p.method_10063()));
    }

    default public void loadControllerPos(class_2487 tag) {
        NBTHelper.getLong(tag, CONTROLLER_POS_TAG).ifPresent(value -> {
            class_2338 controllerPos = class_2338.method_10092((long)value);
            this.setControllerPos(controllerPos);
        });
    }

    default public void addToController(class_1937 level, class_2338 pos, class_2338 controllerPos) {
    }

    default public void addToAdjacentController() {
        class_1937 level = this.getStorageBlockLevel();
        if (!level.method_8608()) {
            class_2338 pos = this.getStorageBlockPos();
            for (class_2350 dir : class_2350.values()) {
                class_2338 offsetPos = pos.method_10081(dir.method_10163());
                WorldHelper.getBlockEntity((class_1922)level, offsetPos, IControllerBoundable.class).ifPresentOrElse(s -> {
                    if (s.canConnectStorages()) {
                        s.getControllerPos().ifPresent(controllerPos -> this.addToController(level, pos, (class_2338)controllerPos));
                    }
                }, () -> this.addToController(level, pos, offsetPos));
                if (this.getControllerPos().isPresent()) break;
            }
        }
    }
}

