/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client;

import java.util.Collections;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5632;
import net.minecraft.class_634;
import net.minecraft.class_7225;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.init.ModParticles;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.event.client.ClientRecipesUpdated;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;
import org.jetbrains.annotations.NotNull;

public class ClientEventHandler
implements ClientModInitializer {
    public void onInitializeClient() {
        ModParticles.registerFactories();
        ClientEventHandler.registerFluidClientExtension();
        ServerWorldEvents.UNLOAD.register(StorageSoundHandler::onWorldUnload);
        ClientTickEvents.END_WORLD_TICK.register(StorageSoundHandler::tick);
        ClientPlayConnectionEvents.JOIN.register(ClientEventHandler::onPlayerJoinServer);
        ClientRecipesUpdated.EVENT.register(RecipeHelper::onRecipesUpdated);
        ScreenEvents.BEFORE_INIT.register((client, screen, windowWidth, windowHeight) -> {
            if (!(screen instanceof class_465) || screen instanceof class_481 || client.field_1724 == null) {
                return;
            }
            ScreenEvents.afterRender((class_437)screen).register(ClientEventHandler::onDrawScreen);
        });
    }

    private static void onDrawScreen(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY, float tickDelta) {
        class_465 containerGui;
        class_310 mc;
        block9: {
            block8: {
                mc = class_310.method_1551();
                class_437 gui = mc.field_1755;
                if (!(gui instanceof class_465)) break block8;
                containerGui = (class_465)gui;
                if (!(gui instanceof class_481) && mc.field_1724 != null) break block9;
            }
            return;
        }
        class_1703 menu = containerGui.method_17577();
        class_1799 held = menu.method_34255();
        if (!held.method_7960()) {
            Object object;
            class_1735 under = containerGui.sophisticatedCore_getSlotUnderMouse();
            if (menu instanceof StorageContainerMenuBase) {
                StorageContainerMenuBase storageMenu = (StorageContainerMenuBase)menu;
                object = storageMenu.realInventorySlots;
            } else {
                object = menu.field_7761;
            }
            class_2371 slots = object;
            for (class_1735 s : slots) {
                Optional<StashResultAndTooltip> stashResultAndTooltip;
                class_1799 stack = s.method_7677();
                if (!s.method_7674((class_1657)mc.field_1724) || stack.method_7960() || (stashResultAndTooltip = ClientEventHandler.getStashResultAndTooltip(stack, held)).isEmpty()) continue;
                if (s == under) {
                    ClientEventHandler.renderSpecialTooltip(mc, guiGraphics, mouseX, mouseY, stashResultAndTooltip.get());
                    continue;
                }
                ClientEventHandler.renderStashSign(mc, containerGui, guiGraphics, s, stack, stashResultAndTooltip.get().stashResult());
            }
        }
    }

    private static void renderStashSign(class_310 mc, class_465<?> containerGui, class_332 guiGraphics, class_1735 s, class_1799 stack, IStashStorageItem.StashResult stashResult) {
        int color;
        int x = containerGui.sophisticatedCore_getGuiLeft() + s.field_7873;
        int y = containerGui.sophisticatedCore_getGuiTop() + s.field_7872;
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 330.0f);
        int n = color = stashResult == IStashStorageItem.StashResult.MATCH_AND_SPACE ? class_124.field_1060.method_532() : 0xFFFF00;
        if (stack.method_7909() instanceof IStashStorageItem) {
            guiGraphics.method_25303(mc.field_1772, "+", x + 10, y + 8, color);
        } else {
            guiGraphics.method_25303(mc.field_1772, "-", x + 1, y, color);
        }
        poseStack.method_22909();
    }

    private static void renderSpecialTooltip(class_310 mc, class_332 guiGraphics, int x, int y, StashResultAndTooltip stashResultAndTooltip) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 100.0f);
        guiGraphics.method_51437(mc.field_1772, Collections.singletonList(class_2561.method_43471((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".right_click_to_add_to_storage"))), stashResultAndTooltip.tooltip(), x, y);
        poseStack.method_22909();
    }

    private static Optional<StashResultAndTooltip> getStashResultAndTooltip(class_1799 inInventory, class_1799 held) {
        class_1792 class_17922;
        if (inInventory.method_7947() == 1 && (class_17922 = inInventory.method_7909()) instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)class_17922;
            return ClientEventHandler.getStashResultAndTooltip(inInventory, held, stashStorageItem);
        }
        class_17922 = held.method_7909();
        if (class_17922 instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)class_17922;
            return ClientEventHandler.getStashResultAndTooltip(held, inInventory, stashStorageItem);
        }
        return Optional.empty();
    }

    @NotNull
    private static Optional<StashResultAndTooltip> getStashResultAndTooltip(class_1799 potentialStashStorage, class_1799 potentiallyStashable, IStashStorageItem stashStorageItem) {
        IStashStorageItem.StashResult stashResult = stashStorageItem.getItemStashable((class_7225.class_7874)class_310.method_1551().field_1687.method_30349(), potentialStashStorage, potentiallyStashable);
        if (stashResult == IStashStorageItem.StashResult.NO_SPACE) {
            return Optional.empty();
        }
        return Optional.of(new StashResultAndTooltip(stashResult, stashStorageItem.getInventoryTooltip(potentialStashStorage)));
    }

    private static void onPlayerJoinServer(class_634 handler, PacketSender sender, class_310 client) {
        RecipeHelper.setLevel((class_1937)class_310.method_1551().field_1687);
    }

    private static void registerFluidClientExtension() {
        FluidRenderHandlerRegistry.INSTANCE.register((class_3611)ModFluids.XP_STILL.get(), (class_3611)ModFluids.XP_FLOWING.get(), (FluidRenderHandler)new SimpleFluidRenderHandler(SophisticatedCore.getRL("block/xp_still"), SophisticatedCore.getRL("block/xp_flowing")));
    }

    private record StashResultAndTooltip(IStashStorageItem.StashResult stashResult, Optional<class_5632> tooltip) {
    }
}

