/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.fabric.rsls.common;

import com.ishland.fabric.rsls.common.SourcesLimitProber;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3532;

public class RSLSConfig {
    private static final Path CONFIG_FILE;
    public static final int probedMaxSourcesCount;
    public static int maxSourcesCount;
    public static int maxStreamingSources;

    public static void init() {
    }

    public static void loadConfig() {
        Properties properties = new Properties();
        if (Files.isRegularFile(CONFIG_FILE, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(CONFIG_FILE, StandardOpenOption.CREATE);){
                properties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        maxSourcesCount = class_3532.method_15340((int)RSLSConfig.getInt(properties, "maxSourcesCount", probedMaxSourcesCount), (int)32, (int)probedMaxSourcesCount);
        maxStreamingSources = class_3532.method_15340((int)RSLSConfig.getInt(properties, "maxStreamingSources", 8), (int)8, (int)probedMaxSourcesCount);
        RSLSConfig.saveConfig();
    }

    public static void saveConfig() {
        Properties properties = new Properties();
        properties.setProperty("maxSourcesCount", String.valueOf(maxSourcesCount));
        properties.setProperty("maxStreamingSources", String.valueOf(maxStreamingSources));
        try (OutputStream out = Files.newOutputStream(CONFIG_FILE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            properties.store(out, "Configuration file for Raise Sound Limit Simplified");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getInt(Properties properties, String key, int def) {
        try {
            int i = Integer.parseInt(properties.getProperty(key));
            properties.setProperty(key, String.valueOf(i));
            return i;
        }
        catch (NumberFormatException e) {
            properties.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    static {
        int count;
        CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("rsls.properties");
        try {
            count = SourcesLimitProber.probeSourcesLimit();
        }
        catch (Throwable t) {
            System.err.println("Failed to probe max sources count, falling back to default value.");
            t.printStackTrace();
            count = 4095;
        }
        maxSourcesCount = probedMaxSourcesCount = count;
        maxStreamingSources = 8;
        RSLSConfig.loadConfig();
    }
}

