/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.fabric.network;

import corgitaco.corgilib.network.Packet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3222;

public class FabricNetworkHandler {
    public static void init() {
        Packet.PACKETS.forEach(FabricNetworkHandler::register);
    }

    private static <T extends Packet> void register(Packet.Handler<T> handler) {
        if (handler.direction() == Packet.PacketDirection.SERVER_TO_CLIENT) {
            PayloadTypeRegistry.playS2C().register(handler.type(), handler.serializer());
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                ClientProxy.registerClientReceiver(handler);
            }
        }
        if (handler.direction() == Packet.PacketDirection.CLIENT_TO_SERVER) {
            PayloadTypeRegistry.playC2S().register(handler.type(), handler.serializer());
            ServerProxy.registerServerReceiver(handler);
        }
        if (handler.direction() == Packet.PacketDirection.BI_DIRECTIONAL) {
            PayloadTypeRegistry.playC2S().register(handler.type(), handler.serializer());
            PayloadTypeRegistry.playS2C().register(handler.type(), handler.serializer());
            ServerProxy.registerServerReceiver(handler);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                ClientProxy.registerClientReceiver(handler);
            }
        }
    }

    public static <MSG extends Packet> void sendToPlayer(class_3222 player, MSG packet) {
        ServerPlayNetworking.send((class_3222)player, packet);
    }

    public static <MSG extends Packet> void sendToAllPlayers(List<class_3222> players, MSG packet) {
        players.forEach(player -> FabricNetworkHandler.sendToPlayer(player, packet));
    }

    public static <MSG extends Packet> void sendToServer(MSG packet) {
        ClientPlayNetworking.send(packet);
    }

    public record ClientProxy() {
        public static <T extends Packet> void registerClientReceiver(Packet.Handler<T> handler) {
            ClientPlayNetworking.registerGlobalReceiver(handler.type(), (t, context) -> handler.handle().handle((Packet)t, (class_1937)context.client().field_1687, (class_1657)context.player()));
        }
    }

    public static class ServerProxy {
        private static <T extends Packet> void registerServerReceiver(Packet.Handler<T> handler) {
            ServerPlayNetworking.registerGlobalReceiver(handler.type(), (t, context) -> handler.handle().handle((Packet)t, context.player().method_37908(), (class_1657)context.player()));
        }
    }
}

