/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_310;
import org.teacon.slides.Slideshow;
import org.teacon.slides.cache.ImageCache;
import org.teacon.slides.slide.IconSlide;
import org.teacon.slides.slide.ImageSlide;
import org.teacon.slides.slide.Slide;
import org.teacon.slides.texture.AnimatedTextureProvider;
import org.teacon.slides.texture.GIFDecoder;
import org.teacon.slides.texture.StaticTextureProvider;
import org.teacon.slides.texture.TextureProvider;

public final class SlideState {
    private static final Executor RENDER_EXECUTOR = r -> RenderSystem.recordRenderCall(r::run);
    private static final AtomicReference<ConcurrentHashMap<String, SlideState>> sCache = new AtomicReference(new ConcurrentHashMap());
    private static int cleanerTimer = 0;
    private static long animationTick = 0L;
    private static final int RECYCLE_SECONDS = 120;
    private static final int RETRY_INTERVAL_SECONDS = 30;
    private static final int CLEANER_INTERVAL_SECONDS = 720;
    private Slide mSlide;
    private State mState;
    private int mCounter;

    public static void tick(class_310 minecraft) {
        if (!minecraft.method_1493() && ++animationTick % 20L == 0L) {
            ConcurrentHashMap<String, SlideState> map = sCache.getAcquire();
            if (!map.isEmpty()) {
                map.entrySet().removeIf(entry -> ((SlideState)entry.getValue()).update());
            }
            if (++cleanerTimer > 720) {
                int n = ImageCache.getInstance().cleanResources();
                if (n != 0) {
                    Slideshow.LOGGER.debug("Cleanup {} http cache image resources", (Object)n);
                }
                cleanerTimer = 0;
            }
        }
    }

    public static void onPlayerLeft() {
        RenderSystem.recordRenderCall(() -> {
            ConcurrentHashMap map = sCache.getAndSet(new ConcurrentHashMap());
            map.values().forEach(s -> s.mSlide.close());
            Slideshow.LOGGER.debug("Release {} slide images", (Object)map.size());
            map.clear();
        });
    }

    public static long getAnimationTick() {
        return animationTick;
    }

    public static Slide getSlide(@Nonnull String location) {
        if (location.isEmpty()) {
            return null;
        }
        return sCache.getAcquire().computeIfAbsent(location, SlideState::new).getWithUpdate();
    }

    private SlideState(String location) {
        URI uri = SlideState.createURI(location);
        if (uri == null) {
            this.mSlide = Slide.failed();
            this.mState = State.FAILED;
            this.mCounter = 30;
        } else {
            this.mSlide = Slide.loading();
            this.mState = State.LOADING;
            this.mCounter = 120;
            ((CompletableFuture)((CompletableFuture)ImageCache.getInstance().getResource(uri, true).thenCompose(SlideState::createTexture)).thenAccept(textureProvider -> {
                if (this.mState == State.LOADING) {
                    this.mSlide = Slide.make(textureProvider);
                    this.mState = State.LOADED;
                } else {
                    assert (this.mState == State.LOADED);
                    textureProvider.close();
                }
            })).exceptionally(e -> {
                RenderSystem.recordRenderCall(() -> {
                    assert (this.mState == State.LOADING);
                    this.mSlide = Slide.failed();
                    this.mState = State.FAILED;
                    this.mCounter = 30;
                });
                return null;
            });
        }
    }

    @Nonnull
    private Slide getWithUpdate() {
        if (this.mState != State.FAILED) {
            this.mCounter = 120;
        }
        return this.mSlide;
    }

    private boolean update() {
        if (--this.mCounter < 0) {
            RenderSystem.recordRenderCall(() -> {
                if (this.mState == State.LOADED) {
                    assert (this.mSlide instanceof ImageSlide);
                    this.mSlide.close();
                } else if (this.mState == State.LOADING) {
                    assert (this.mSlide == Slide.loading());
                    this.mState = State.LOADED;
                } else {
                    assert (this.mSlide instanceof IconSlide);
                    assert (this.mState == State.FAILED);
                }
            });
            return true;
        }
        return false;
    }

    @Nullable
    public static URI createURI(@Nonnull String location) {
        if (!location.isEmpty()) {
            try {
                return URI.create(location);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Nonnull
    private static CompletableFuture<TextureProvider> createTexture(byte[] data) {
        return CompletableFuture.supplyAsync(GIFDecoder.checkMagic(data) ? () -> new AnimatedTextureProvider(data) : () -> new StaticTextureProvider(data), RENDER_EXECUTOR);
    }

    public static enum State {
        FAILED,
        LOADING,
        NORMAL,
        LOADED;

    }
}

