/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.renderer;

import javax.annotation.Nonnull;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_827;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.teacon.slides.config.Config;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.renderer.SlideState;
import org.teacon.slides.slide.Slide;

public final class ProjectorRenderer
implements class_827<ProjectorBlockEntity> {
    public void render(@Nonnull ProjectorBlockEntity blockEntity, float partialTick, @Nonnull class_4587 poseStack, @Nonnull class_4597 source, int packedLight, int packedOverlay) {
        class_2680 blockState = blockEntity.method_11010();
        Slide slide = SlideState.getSlide(blockEntity.getProjectorBlockEntityData().getLocation());
        if (slide != null) {
            float width = blockEntity.getProjectorBlockEntityData().getWidth();
            float height = blockEntity.getProjectorBlockEntityData().getHeight();
            int color = blockEntity.getProjectorBlockEntityData().getColor();
            boolean isTransparent = (color & 0xFF000000) == 0;
            boolean isPowered = (Boolean)blockState.method_11654((class_2769)class_2741.field_12484);
            boolean doubleSided = blockEntity.getProjectorBlockEntityData().isDoubleSided();
            if (!isTransparent && !isPowered) {
                poseStack.method_22903();
                class_4587.class_4665 lastPose = poseStack.method_23760();
                Matrix4f pose = new Matrix4f((Matrix4fc)lastPose.method_23761());
                Matrix3f normal = new Matrix3f((Matrix3fc)lastPose.method_23762());
                blockEntity.transformToSlideSpace(pose, normal);
                boolean flipped = ((ProjectorBlock.InternalRotation)((Object)blockState.method_11654(ProjectorBlock.ROTATION))).isFlipped();
                slide.render(source, pose, lastPose, width, height, color, 0xF000F0, flipped || doubleSided, !flipped || doubleSided, SlideState.getAnimationTick(), partialTick);
                poseStack.method_22909();
            }
        }
    }

    public boolean shouldRenderOffScreen(@Nonnull ProjectorBlockEntity blockEntity) {
        return true;
    }

    public int method_33893() {
        return Config.getViewDistance();
    }
}

