/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.storage.quests;

import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extraquests.ExtraQuests;
import com.vecoo.extraquests.storage.quests.TimerStorage;
import com.vecoo.extraquests.util.Utils;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;

public class TimerProvider {
    private final transient String filePath;
    private final Set<TimerStorage> timers;

    public TimerProvider(String filePath, MinecraftServer server) {
        this.filePath = UtilWorld.worldDirectory((String)filePath, (MinecraftServer)server);
        this.timers = ConcurrentHashMap.newKeySet();
    }

    public Set<TimerStorage> getTimers() {
        return this.timers;
    }

    public boolean addTimer(TimerStorage timer) {
        if (!this.timers.add(timer)) {
            ExtraQuests.getLogger().error("[ExtraQuests] Failed to add timer " + timer.toString());
            return false;
        }
        this.write();
        return true;
    }

    public boolean removeTimer(TimerStorage timer) {
        if (!this.timers.remove(timer)) {
            ExtraQuests.getLogger().error("[ExtraQuests] Failed to remove timer " + timer.toString());
            return false;
        }
        this.write();
        return true;
    }

    private void write() {
        UtilGson.writeFileAsync((String)this.filePath, (String)"TimerStorage.json", (String)UtilGson.newGson().toJson((Object)this)).join();
    }

    public void init() {
        CompletableFuture future = UtilGson.readFileAsync((String)this.filePath, (String)"TimerStorage.json", el -> {
            TimerProvider provider = (TimerProvider)UtilGson.newGson().fromJson(el, TimerProvider.class);
            long time = System.currentTimeMillis();
            for (TimerStorage timer : provider.getTimers()) {
                if (timer.getEndTime() > time) {
                    this.timers.add(timer);
                    Utils.startTimer(timer);
                    continue;
                }
                Utils.questReset(timer);
            }
            this.write();
        });
        if (!((Boolean)future.join()).booleanValue()) {
            this.write();
        }
    }
}

