/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.config;

import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extraquests.ExtraQuests;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ServerConfig {
    private boolean blacklistConsole = false;
    private List<String> blacklistConsoleList = Arrays.asList("op", "gamemode");

    public boolean isBlacklistConsole() {
        return this.blacklistConsole;
    }

    public List<String> getBlacklistConsoleList() {
        return this.blacklistConsoleList;
    }

    private void write() {
        UtilGson.writeFileAsync((String)"/config/ExtraQuests/", (String)"config.json", (String)UtilGson.newGson().toJson((Object)this)).join();
    }

    public void init() {
        try {
            CompletableFuture future = UtilGson.readFileAsync((String)"/config/ExtraQuests/", (String)"config.json", el -> {
                ServerConfig config = (ServerConfig)UtilGson.newGson().fromJson(el, ServerConfig.class);
                this.blacklistConsole = config.isBlacklistConsole();
                this.blacklistConsoleList = config.getBlacklistConsoleList();
            });
            if (!((Boolean)future.join()).booleanValue()) {
                this.write();
            }
        }
        catch (Exception e) {
            ExtraQuests.getLogger().error("[ExtraQuests] Error in config.", (Throwable)e);
            this.write();
        }
    }
}

