/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extraquests.ExtraQuests;
import com.vecoo.extraquests.task.KeyValueTask;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import java.util.Arrays;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class ExtraQuestsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"equests").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)"minecraft.command.equests"))).then(class_2170.method_9247((String)"key_value").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).suggests((s, builder) -> {
            for (String playerName : ((class_2168)s.getSource()).method_9262()) {
                if (!playerName.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(playerName);
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests((s, builder) -> {
            for (int amount : Arrays.asList(10, 50, 100)) {
                builder.suggest(amount);
            }
            return builder.buildFuture();
        }).executes(e -> ExtraQuestsCommand.executeKeyValueAdd((class_2168)e.getSource(), class_2186.method_9315((CommandContext)e, (String)"player"), StringArgumentType.getString((CommandContext)e, (String)"key"), IntegerArgumentType.getInteger((CommandContext)e, (String)"amount"))))))))).then(class_2170.method_9247((String)"reload").executes(e -> ExtraQuestsCommand.executeReload((class_2168)e.getSource()))));
    }

    private static int executeKeyValueAdd(class_2168 source, class_3222 target, String key, int amount) {
        for (KeyValueTask task : ServerQuestFile.INSTANCE.collect(KeyValueTask.class)) {
            task.progress(ServerQuestFile.INSTANCE.getOrCreateTeamData((class_1297)target), key, amount);
        }
        source.method_45068((class_2561)UtilChat.formatMessage((String)ExtraQuests.getInstance().getLocale().getAddKeyValueSource().replace("%player%", target.method_7334().getName()).replace("%key%", key).replace("%value%", String.valueOf(amount))));
        target.method_43496((class_2561)UtilChat.formatMessage((String)ExtraQuests.getInstance().getLocale().getAddKeyValueTarget().replace("%key%", key).replace("%value%", String.valueOf(amount))));
        return 1;
    }

    private static int executeReload(class_2168 source) {
        ExtraQuests.getInstance().loadConfig();
        ExtraQuests.getInstance().loadStorage();
        source.method_45068((class_2561)UtilChat.formatMessage((String)ExtraQuests.getInstance().getLocale().getReload()));
        return 1;
    }
}

