/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.spawner;

import com.mojang.serialization.DynamicOps;
import net.minecraft.class_1299;
import net.minecraft.class_1952;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_6005;
import net.minecraft.class_7923;

public class MobSpawnerData {
    public final int spawnDelay;
    public final class_6005<class_1952> spawnPotentials;
    public final class_1952 nextSpawnData;
    public final int minSpawnDelay;
    public final int maxSpawnDelay;
    public final int spawnCount;
    public final int maxNearbyEntities;
    public final int requiredPlayerRange;
    public final int spawnRange;

    public MobSpawnerData(Builder builder) {
        this.spawnDelay = builder.spawnDelay;
        this.spawnPotentials = builder.spawnPotentials;
        this.nextSpawnData = builder.nextSpawnData;
        this.minSpawnDelay = builder.minSpawnDelay;
        this.maxSpawnDelay = builder.maxSpawnDelay;
        this.spawnCount = builder.spawnCount;
        this.maxNearbyEntities = builder.maxNearbyEntities;
        this.requiredPlayerRange = builder.requiredPlayerRange;
        this.spawnRange = builder.spawnRange;
    }

    public class_2487 save() {
        return this.save(new class_2487());
    }

    public class_2487 save(class_2487 compoundTag) {
        compoundTag.method_10575("Delay", (short)this.spawnDelay);
        compoundTag.method_10575("MinSpawnDelay", (short)this.minSpawnDelay);
        compoundTag.method_10575("MaxSpawnDelay", (short)this.maxSpawnDelay);
        compoundTag.method_10575("SpawnCount", (short)this.spawnCount);
        compoundTag.method_10575("MaxNearbyEntities", (short)this.maxNearbyEntities);
        compoundTag.method_10575("RequiredPlayerRange", (short)this.requiredPlayerRange);
        compoundTag.method_10575("SpawnRange", (short)this.spawnRange);
        compoundTag.method_10566("SpawnData", (class_2520)class_1952.field_34460.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.nextSpawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        compoundTag.method_10566("SpawnPotentials", (class_2520)class_1952.field_34461.encodeStart((DynamicOps)class_2509.field_11560, this.spawnPotentials).result().orElseThrow());
        return compoundTag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int spawnDelay = 20;
        private class_6005<class_1952> spawnPotentials = class_6005.method_38062();
        private class_1952 nextSpawnData = new class_1952();
        private int minSpawnDelay = 200;
        private int maxSpawnDelay = 800;
        private int spawnCount = 4;
        private int maxNearbyEntities = 6;
        private int requiredPlayerRange = 16;
        private int spawnRange = 4;

        public MobSpawnerData build() {
            return new MobSpawnerData(this);
        }

        public Builder spawnDelay(int spawnDelay) {
            this.spawnDelay = spawnDelay;
            return this;
        }

        public Builder spawnPotentials(class_6005<class_1952> spawnPotentials) {
            this.spawnPotentials = spawnPotentials;
            return this;
        }

        public Builder setEntityType(class_1299<?> entityType) {
            this.nextSpawnData.method_38093().method_10582("id", class_7923.field_41177.method_10221(entityType).toString());
            return this;
        }

        public Builder minSpawnDelay(int minSpawnDelay) {
            this.minSpawnDelay = minSpawnDelay;
            return this;
        }

        public Builder maxSpawnDelay(int maxSpawnDelay) {
            this.maxSpawnDelay = maxSpawnDelay;
            return this;
        }

        public Builder spawnCount(int spawnCount) {
            this.spawnCount = spawnCount;
            return this;
        }

        public Builder maxNearbyEntities(int maxNearbyEntities) {
            this.maxNearbyEntities = maxNearbyEntities;
            return this;
        }

        public Builder requiredPlayerRange(int requiredPlayerRange) {
            this.requiredPlayerRange = requiredPlayerRange;
            return this;
        }

        public Builder spawnRange(int spawnRange) {
            this.spawnRange = spawnRange;
            return this;
        }
    }
}

