/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.registry.tool;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3545;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.IRegistryDataLoader;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.BlockContext;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.IMatcherFactory;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.Matchers;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ModMatcher;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;

public class ToolRegistry {
    private static final String TOOLS_PROPERTY = "tools";
    private static final Set<String> modsWithMapping = new HashSet<String>();
    private static final ToolMapping<class_2248, BlockContext> BLOCK_TOOL_MAPPING = new ToolMapping<class_2248, BlockContext>((class_2378<class_2248>)class_7923.field_41175, BlockContext::getBlock);
    private static final ToolMapping<class_1299<?>, class_1297> ENTITY_TOOL_MAPPING = new ToolMapping<class_1299, class_1297>((class_2378<class_1299>)class_7923.field_41177, class_1297::method_5864);

    private ToolRegistry() {
    }

    public static boolean isToolForBlock(class_1799 stack, class_2248 block, class_1937 level, class_2680 blockState, class_2338 pos) {
        return BLOCK_TOOL_MAPPING.isToolFor(stack, block, () -> new BlockContext(level, blockState, block, pos));
    }

    public static boolean isToolForEntity(class_1799 stack, class_1297 entity) {
        return ENTITY_TOOL_MAPPING.isToolFor(stack, entity.method_5864(), () -> entity);
    }

    protected static class_3545<Set<class_1792>, Set<Predicate<class_1799>>> getItemsAndItemPredicates(Map.Entry<String, JsonElement> property) {
        if (property.getValue().isJsonArray()) {
            JsonArray toolArray = class_3518.method_15252((JsonElement)property.getValue(), (String)"");
            return ToolRegistry.getItemsAndItemPredicates(toolArray);
        }
        SophisticatedBackpacks.LOGGER.error("Invalid tools list - needs to be an array {}", (Object)property.getValue());
        return new class_3545(Collections.emptySet(), Collections.emptySet());
    }

    protected static class_3545<Set<class_1792>, Set<Predicate<class_1799>>> getItemsAndItemPredicates(JsonArray toolArray) {
        HashSet<class_1792> items = new HashSet<class_1792>();
        HashSet itemPredicates = new HashSet();
        for (JsonElement jsonElement : toolArray) {
            if (jsonElement.isJsonPrimitive()) {
                class_2960 itemName = class_2960.method_60654((String)jsonElement.getAsString());
                if (!class_7923.field_41178.method_10250(itemName)) {
                    SophisticatedBackpacks.LOGGER.debug("{} isn't loaded in item registry, skipping ...", (Object)itemName);
                }
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemName);
                items.add(item);
                continue;
            }
            if (!jsonElement.isJsonObject()) continue;
            Matchers.getItemMatcher(jsonElement).ifPresent(itemPredicates::add);
        }
        return new class_3545(items, itemPredicates);
    }

    public static void addModWithMapping(String modId) {
        modsWithMapping.add(modId);
    }

    private static class ToolMapping<V, C> {
        private final class_2378<V> registry;
        private final Function<C, V> getObjectFromContext;
        private final Map<V, Set<class_1792>> notToolCache = new HashMap<V, Set<class_1792>>();
        private final Map<V, Set<class_1792>> objectTools = new HashMap<V, Set<class_1792>>();
        private final Map<V, Set<Predicate<class_1799>>> objectToolPredicates = new HashMap<V, Set<Predicate<class_1799>>>();
        private final Map<Predicate<C>, Set<class_1792>> objectPredicateTools = new HashMap<Predicate<C>, Set<class_1792>>();
        private final Map<Predicate<C>, Set<Predicate<class_1799>>> objectPredicateToolPredicates = new HashMap<Predicate<C>, Set<Predicate<class_1799>>>();

        public ToolMapping(class_2378<V> registry, Function<C, V> getObjectFromContext) {
            this.registry = registry;
            this.getObjectFromContext = getObjectFromContext;
        }

        private void addObjectPredicateTools(class_3545<Set<class_1792>, Set<Predicate<class_1799>>> tools, Predicate<C> predicate) {
            ((Set)tools.method_15442()).forEach(t -> this.objectPredicateTools.computeIfAbsent(predicate, p -> new HashSet()).add(t));
            ((Set)tools.method_15441()).forEach(tp -> this.objectPredicateToolPredicates.computeIfAbsent(predicate, p -> new HashSet()).add(tp));
        }

        private void addObjectTools(class_3545<Set<class_1792>, Set<Predicate<class_1799>>> tools, V object) {
            ((Set)tools.method_15442()).forEach(t -> this.objectTools.computeIfAbsent((Set)object, (Function<Set, Set<class_1792>>)((Function<Object, Set>)b -> new HashSet())).add(t));
            ((Set)tools.method_15441()).forEach(tp -> this.objectToolPredicates.computeIfAbsent((Set)object, (Function<Set, Set<Predicate<class_1799>>>)((Function<Object, Set>)b -> new HashSet())).add(tp));
        }

        public void clear() {
            this.notToolCache.clear();
            this.objectTools.clear();
            this.objectToolPredicates.clear();
            this.objectPredicateTools.clear();
            this.objectPredicateToolPredicates.clear();
        }

        public boolean isToolFor(class_1799 stack, V object, Supplier<C> getContext) {
            class_1792 item = stack.method_7909();
            if (this.objectTools.containsKey(object) && this.objectTools.get(object).contains(item)) {
                return true;
            }
            if (this.notToolCache.containsKey(object) && this.notToolCache.get(object).contains(item)) {
                return false;
            }
            if (this.tryToMatchAgainstObjectToolPredicates(stack, object)) {
                return true;
            }
            C context = getContext.get();
            if (this.tryToMatchAgainstObjectPredicateTools(item, context)) {
                return true;
            }
            if (this.tryToMatchAgainstObjectPredicateToolPredicates(stack, context)) {
                return true;
            }
            if (this.tryToMatchNoMappingMod(stack, object)) {
                return true;
            }
            this.notToolCache.computeIfAbsent((Set)object, (Function<Set, Set<class_1792>>)((Function<Object, Set>)b -> new HashSet())).add(item);
            return false;
        }

        private boolean tryToMatchNoMappingMod(class_1799 stack, V object) {
            if (this.isNoMappingModAndNonStackableItemFromSameMod(stack, object)) {
                this.addObjectToolMapping(object, stack.method_7909());
                return true;
            }
            return false;
        }

        private boolean isNoMappingModAndNonStackableItemFromSameMod(class_1799 stack, V object) {
            return RegistryHelper.getRegistryName(this.registry, object).map(rn -> !rn.method_12836().equals("minecraft") && !modsWithMapping.contains(rn.method_12836()) && RegistryHelper.getRegistryName((class_2378)class_7923.field_41178, (Object)stack.method_7909()).map(itemRegistryName -> itemRegistryName.method_12836().equals(rn.method_12836())).orElse(false) != false).orElse(false) != false && stack.method_7914() == 1;
        }

        private boolean tryToMatchAgainstObjectPredicateToolPredicates(class_1799 stack, C context) {
            for (Map.Entry<Predicate<C>, Set<Predicate<class_1799>>> entry : this.objectPredicateToolPredicates.entrySet()) {
                if (!entry.getKey().test(context)) continue;
                Set<Predicate<class_1799>> toolPredicates = entry.getValue();
                if (!this.tryToMatchTools(stack, this.getObjectFromContext.apply(context), toolPredicates)) continue;
                return true;
            }
            return false;
        }

        private boolean tryToMatchAgainstObjectToolPredicates(class_1799 stack, V object) {
            if (this.objectToolPredicates.containsKey(object)) {
                Set<Predicate<class_1799>> toolPredicates = this.objectToolPredicates.get(object);
                return this.tryToMatchTools(stack, object, toolPredicates);
            }
            return false;
        }

        private boolean tryToMatchAgainstObjectPredicateTools(class_1792 item, C context) {
            for (Map.Entry<Predicate<C>, Set<class_1792>> entry : this.objectPredicateTools.entrySet()) {
                if (!entry.getKey().test(context) || !entry.getValue().contains(item)) continue;
                this.addObjectToolMapping(this.getObjectFromContext.apply(context), item);
                return true;
            }
            return false;
        }

        private boolean tryToMatchTools(class_1799 stack, V object, Set<Predicate<class_1799>> toolPredicates) {
            for (Predicate<class_1799> itemPredicate : toolPredicates) {
                if (!itemPredicate.test(stack)) continue;
                this.objectTools.computeIfAbsent((Set)object, (Function<Set, Set<class_1792>>)((Function<Object, Set>)b -> new HashSet())).add(stack.method_7909());
                return true;
            }
            return false;
        }

        private void addObjectToolMapping(V block, class_1792 item) {
            this.objectTools.computeIfAbsent((Set)block, (Function<Set, Set<class_1792>>)((Function<Object, Set>)b -> new HashSet())).add(item);
        }

        public Map<V, Set<class_1792>> getObjectTools() {
            return this.objectTools;
        }

        public void addModPredicateTools(String modId, class_3545<Set<class_1792>, Set<Predicate<class_1799>>> tools) {
            this.addObjectPredicateTools(tools, new ModMatcher<V, class_2378<V>, C>(this.registry, modId, this.getObjectFromContext));
        }
    }

    public static class EntityToolsLoader
    extends ToolsLoaderBase<class_1299<?>, class_1297> {
        public EntityToolsLoader() {
            super(Matchers.getEntityMatcherFactories(), ENTITY_TOOL_MAPPING, class_7923.field_41177, arg_0 -> ((class_7922)class_7923.field_41177).method_17966(arg_0), "entity_tools", "entities");
        }
    }

    public static class BlockToolsLoader
    extends ToolsLoaderBase<class_2248, BlockContext> {
        public BlockToolsLoader() {
            super(Matchers.getBlockMatcherFactories(), BLOCK_TOOL_MAPPING, class_7923.field_41175, arg_0 -> ((class_7922)class_7923.field_41175).method_17966(arg_0), "block_tools", "blocks");
        }
    }

    private static abstract class ToolsLoaderBase<V, C>
    implements IRegistryDataLoader {
        private final List<IMatcherFactory<C>> objectMatcherFactories;
        private final ToolMapping<V, C> toolMapping;
        private final class_2378<V> registry;
        private final Function<class_2960, Optional<V>> getObjectFromRegistry;
        private final String name;
        private final String objectJsonArrayName;

        public ToolsLoaderBase(List<IMatcherFactory<C>> objectMatcherFactories, ToolMapping<V, C> toolMapping, class_2378<V> registry, Function<class_2960, Optional<V>> getObjectFromRegistry, String name, String objectJsonArrayName) {
            this.objectMatcherFactories = objectMatcherFactories;
            this.toolMapping = toolMapping;
            this.registry = registry;
            this.getObjectFromRegistry = getObjectFromRegistry;
            this.name = name;
            this.objectJsonArrayName = objectJsonArrayName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void parse(JsonObject json, @Nullable String modId) {
            JsonArray toolsMap = class_3518.method_15261((JsonObject)json, (String)this.name);
            for (JsonElement jsonElement : toolsMap) {
                if (!jsonElement.isJsonObject()) continue;
                JsonObject entry = jsonElement.getAsJsonObject();
                this.parseEntry(entry);
            }
            this.toolMapping.getObjectTools().keySet().forEach(object -> RegistryHelper.getRegistryName(this.registry, (Object)object).ifPresent(rn -> modsWithMapping.add(rn.method_12836())));
        }

        @Override
        public void clear() {
            this.toolMapping.clear();
            modsWithMapping.clear();
        }

        private void parseEntry(JsonObject entry) {
            if (entry.size() == 1) {
                this.parseFromProperty(entry);
            } else if (entry.size() == 2 && entry.has(this.objectJsonArrayName) && entry.has(ToolRegistry.TOOLS_PROPERTY)) {
                this.parseFromArrays(class_3518.method_15261((JsonObject)entry, (String)this.objectJsonArrayName), class_3518.method_15261((JsonObject)entry, (String)ToolRegistry.TOOLS_PROPERTY));
            } else {
                SophisticatedBackpacks.LOGGER.error("Invalid block tools entry - needs to have either 1 array property with mod/entity name or \"{}\" and \"tools\" array properties {}", (Object)this.objectJsonArrayName, (Object)entry);
            }
        }

        private void parseFromArrays(JsonArray blocksArray, JsonArray toolsArray) {
            class_3545<Set<class_1792>, Set<Predicate<class_1799>>> tools = ToolRegistry.getItemsAndItemPredicates(toolsArray);
            if (((Set)tools.method_15442()).isEmpty() && ((Set)tools.method_15441()).isEmpty()) {
                return;
            }
            for (JsonElement jsonElement : blocksArray) {
                if (jsonElement.isJsonPrimitive() && jsonElement.getAsString().contains(":")) {
                    this.parseObjectEntry(tools, jsonElement.getAsString());
                    continue;
                }
                this.parseObjectPredicateEntry(tools, jsonElement);
            }
        }

        private void parseObjectPredicateEntry(class_3545<Set<class_1792>, Set<Predicate<class_1799>>> tools, JsonElement jsonElement) {
            for (IMatcherFactory<C> blockMatcherFactory : this.objectMatcherFactories) {
                if (!blockMatcherFactory.appliesTo(jsonElement)) continue;
                blockMatcherFactory.getPredicate(jsonElement).ifPresent(predicate -> this.toolMapping.addObjectPredicateTools(tools, (Predicate<C>)predicate));
                break;
            }
        }

        private void parseObjectEntry(class_3545<Set<class_1792>, Set<Predicate<class_1799>>> tools, String objectName) {
            class_2960 registryName = class_2960.method_60654((String)objectName);
            Optional<V> objectOptional = this.getObjectFromRegistry.apply(registryName);
            if (objectOptional.isPresent()) {
                this.toolMapping.addObjectTools(tools, objectOptional.get());
            } else {
                SophisticatedBackpacks.LOGGER.debug("{} doesn't exist in registry, skipping ...", (Object)objectName);
            }
        }

        private void parseFromProperty(JsonObject entry) {
            for (Map.Entry property : entry.entrySet()) {
                if (((String)property.getKey()).contains(":")) {
                    this.parseObjectTools(property);
                    continue;
                }
                this.parseModTools(property);
            }
        }

        private void parseModTools(Map.Entry<String, JsonElement> property) {
            String modId = property.getKey();
            if (!FabricLoader.getInstance().isModLoaded(modId)) {
                SophisticatedBackpacks.LOGGER.debug("{} mod isn't loaded, skipping ... {} ", (Object)modId, property);
                return;
            }
            class_3545<Set<class_1792>, Set<Predicate<class_1799>>> tools = ToolRegistry.getItemsAndItemPredicates(property);
            if (((Set)tools.method_15442()).isEmpty() && ((Set)tools.method_15441()).isEmpty()) {
                return;
            }
            this.toolMapping.addModPredicateTools(modId, tools);
        }

        private void parseObjectTools(Map.Entry<String, JsonElement> property) {
            class_3545<Set<class_1792>, Set<Predicate<class_1799>>> tools = ToolRegistry.getItemsAndItemPredicates(property);
            if (((Set)tools.method_15442()).isEmpty() && ((Set)tools.method_15441()).isEmpty()) {
                return;
            }
            this.parseObjectEntry(tools, property.getKey());
        }
    }
}

