/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.templates.model;

import io.github.cottonmc.templates.Templates;
import io.github.cottonmc.templates.api.TemplatesClientApi;
import io.github.cottonmc.templates.model.MeshTransformUtil;
import io.github.cottonmc.templates.model.QuadUvBounds;
import io.github.cottonmc.templates.model.RetexturingBakedModel;
import io.github.cottonmc.templates.model.TagPacker;
import io.github.cottonmc.templates.model.TemplateAppearanceManager;
import io.github.cottonmc.templates.model.TemplateUnbakedModel;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;

public class UnbakedJsonRetexturedModel
extends TemplateUnbakedModel {
    public UnbakedJsonRetexturedModel(class_2960 parent) {
        super(parent);
    }

    @Override
    public class_1087 bake(class_7775 baker, Function<class_4730, class_1058> spriteLookup, class_3665 modelBakeSettings, class_1087 wrappedModel, TemplateAppearanceManager tam) {
        class_1058[] specialSprites = new class_1058[6];
        for (int i = 0; i < 6; ++i) {
            class_4730 id = new class_4730(class_1723.field_21668, Templates.id("templates_special/" + class_2350.values()[i].method_10151()));
            specialSprites[i] = Objects.requireNonNull(spriteLookup.apply(id), () -> "Couldn't find sprite " + String.valueOf(id) + " !");
        }
        return new RetexturingBakedModel(wrappedModel, this.convertModel(specialSprites, wrappedModel, modelBakeSettings), tam, modelBakeSettings, this.ao);
    }

    protected Mesh convertModel(class_1058[] specialSprites, class_1087 wrapped, class_3665 modelBakeSettings) {
        Renderer r = TemplatesClientApi.getInstance().getFabricRenderer();
        MeshBuilder builder = r.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        RenderMaterial mat = r.materialFinder().find();
        class_5819 rand = class_5819.method_43049((long)42L);
        Map<class_2350, class_2350> facePermutation = MeshTransformUtil.facePermutation(modelBakeSettings);
        for (class_2350 cullFace : RetexturingBakedModel.DIRECTIONS_AND_NULL) {
            for (class_777 quad : wrapped.method_4707(null, cullFace, rand)) {
                emitter.fromVanilla(quad, mat, cullFace);
                QuadUvBounds bounds = QuadUvBounds.read((QuadView)emitter);
                for (int i = 0; i < specialSprites.length; ++i) {
                    if (!bounds.displaysSprite(specialSprites[i])) continue;
                    bounds.normalizeUv((MutableQuadView)emitter, specialSprites[i]);
                    class_2350 dir = RetexturingBakedModel.DIRECTIONS[i];
                    class_2350 permutedDir = facePermutation.get(dir);
                    emitter.tag(TagPacker.withDir(0, permutedDir));
                    break;
                }
                emitter.emit();
            }
        }
        return builder.build();
    }
}

