/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.templates.model;

import io.github.cottonmc.templates.api.TemplateAppearance;
import io.github.cottonmc.templates.api.TemplatesClientApi;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.NotNull;

public class TemplateAppearanceManager {
    private static final class_4730 DEFAULT_SPRITE_ID = new class_4730(class_1723.field_21668, class_2960.method_60654((String)"minecraft:block/scaffolding_top"));
    private static final class_4730 BARRIER_SPRITE_ID = new class_4730(class_1723.field_21668, class_2960.method_60654((String)"minecraft:item/barrier"));
    private final Object initLock = new Object();
    private TemplateAppearance defaultAppearance = null;
    private TemplateAppearance barrierItemAppearance = null;
    private final ConcurrentHashMap<class_2680, TemplateAppearance> appearanceCache = new ConcurrentHashMap();
    private final EnumMap<BlendMode, RenderMaterial> materialsWithAo = new EnumMap(BlendMode.class);
    private final EnumMap<BlendMode, RenderMaterial> materialsWithoutAo = new EnumMap(BlendMode.class);
    private static final int[] MAGIC_BAKEFLAGS_SBOX = new int[16];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ready(Function<class_4730, class_1058> spriteLookup) {
        if (this.barrierItemAppearance != null) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.barrierItemAppearance != null) {
                return;
            }
            this.appearanceCache.clear();
            this.materialsWithAo.clear();
            this.materialsWithoutAo.clear();
            MaterialFinder finder = TemplatesClientApi.getInstance().getFabricRenderer().materialFinder();
            for (BlendMode blend : BlendMode.values()) {
                finder.clear().disableDiffuse(false).blendMode(blend);
                this.materialsWithoutAo.put(blend, finder.ambientOcclusion(TriState.FALSE).find());
                this.materialsWithAo.put(blend, finder.ambientOcclusion(TriState.DEFAULT).find());
            }
            class_1058 defaultSprite = spriteLookup.apply(DEFAULT_SPRITE_ID);
            if (defaultSprite == null) {
                throw new IllegalStateException("Couldn't locate " + String.valueOf(DEFAULT_SPRITE_ID) + " !");
            }
            this.defaultAppearance = new SingleSpriteAppearance(defaultSprite, this.materialsWithoutAo.get(BlendMode.CUTOUT));
            class_1058 barrier = spriteLookup.apply(BARRIER_SPRITE_ID);
            if (barrier == null) {
                barrier = defaultSprite;
            }
            this.barrierItemAppearance = new SingleSpriteAppearance(barrier, this.materialsWithoutAo.get(BlendMode.CUTOUT));
        }
    }

    public TemplateAppearance getDefaultAppearance() {
        return this.defaultAppearance;
    }

    public TemplateAppearance getAppearance(class_2680 state) {
        return this.appearanceCache.computeIfAbsent(state, this::computeAppearance);
    }

    public RenderMaterial getCachedMaterial(class_2680 state, boolean ao) {
        EnumMap<BlendMode, RenderMaterial> m = ao ? this.materialsWithAo : this.materialsWithoutAo;
        return (RenderMaterial)m.get(BlendMode.fromRenderLayer((class_1921)class_4696.method_23679((class_2680)state)));
    }

    private TemplateAppearance computeAppearance(class_2680 state) {
        if (state.method_26204() == class_2246.field_10499) {
            return this.barrierItemAppearance;
        }
        class_5819 rand = class_5819.method_43049((long)42L);
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        Renderer r = TemplatesClientApi.getInstance().getFabricRenderer();
        QuadEmitter emitterAsParser = r.meshBuilder().getEmitter();
        RenderMaterial defaultMat = r.materialFinder().clear().find();
        class_1058[] sprites = new class_1058[6];
        int[] bakeFlags = new int[6];
        byte hasColorMask = 0;
        for (class_2350 dir : class_2350.values()) {
            class_1058 sprite;
            class_777 arbitraryQuad;
            List sideQuads = model.method_4707(state, dir, rand);
            if (sideQuads.isEmpty() || (arbitraryQuad = (class_777)sideQuads.get(0)) == null) continue;
            if (arbitraryQuad.method_3360()) {
                hasColorMask = (byte)(hasColorMask | (byte)(1 << dir.ordinal()));
            }
            if ((sprite = arbitraryQuad.method_35788()) == null) continue;
            sprites[dir.ordinal()] = sprite;
            emitterAsParser.fromVanilla(arbitraryQuad, defaultMat, dir);
            float spriteUAvg = (sprite.method_4594() + sprite.method_4577()) / 2.0f;
            float spriteVAvg = (sprite.method_4593() + sprite.method_4575()) / 2.0f;
            bakeFlags[dir.ordinal()] = MAGIC_BAKEFLAGS_SBOX[(emitterAsParser.u(0) < spriteUAvg ? 8 : 0) | (emitterAsParser.v(0) < spriteVAvg ? 4 : 0) | (emitterAsParser.u(1) < spriteUAvg ? 2 : 0) | (emitterAsParser.v(1) < spriteVAvg ? 1 : 0)];
        }
        for (int i = 0; i < sprites.length; ++i) {
            if (sprites[i] == null) {
                sprites[i] = model.method_4711();
            }
            if (sprites[i] != null) continue;
            sprites[i] = this.defaultAppearance.getSprite(class_2350.method_10143((int)i));
        }
        return new ComputedApperance(sprites, bakeFlags, hasColorMask, this.getCachedMaterial(state, true), this.getCachedMaterial(state, false));
    }

    static {
        TemplateAppearanceManager.MAGIC_BAKEFLAGS_SBOX[14] = 0;
        TemplateAppearanceManager.MAGIC_BAKEFLAGS_SBOX[8] = 1;
        TemplateAppearanceManager.MAGIC_BAKEFLAGS_SBOX[1] = 2;
        TemplateAppearanceManager.MAGIC_BAKEFLAGS_SBOX[7] = 3;
    }

    private static final class SingleSpriteAppearance
    implements TemplateAppearance {
        @NotNull
        private final class_1058 defaultSprite;
        private final RenderMaterial mat;

        private SingleSpriteAppearance(@NotNull class_1058 defaultSprite, RenderMaterial mat) {
            this.defaultSprite = defaultSprite;
            this.mat = mat;
        }

        @Override
        @NotNull
        public RenderMaterial getRenderMaterial(boolean ao) {
            return this.mat;
        }

        @Override
        @NotNull
        public class_1058 getSprite(class_2350 dir) {
            return this.defaultSprite;
        }

        @Override
        public int getBakeFlags(class_2350 dir) {
            return 0;
        }

        @Override
        public boolean hasColor(class_2350 dir) {
            return false;
        }

        public String toString() {
            return "SingleSpriteAppearance[defaultSprite=%s, mat=%s]".formatted(this.defaultSprite, this.mat);
        }
    }

    private static final class ComputedApperance
    implements TemplateAppearance {
        private final class_1058 @NotNull [] sprites;
        private final int @NotNull [] bakeFlags;
        private final byte hasColorMask;
        private final RenderMaterial matWithAo;
        private final RenderMaterial matWithoutAo;

        private ComputedApperance(@NotNull @NotNull class_1058 @NotNull [] sprites, int @NotNull [] bakeFlags, byte hasColorMask, RenderMaterial withAo, RenderMaterial withoutAo) {
            this.sprites = sprites;
            this.bakeFlags = bakeFlags;
            this.hasColorMask = hasColorMask;
            this.matWithAo = withAo;
            this.matWithoutAo = withoutAo;
        }

        @Override
        @NotNull
        public RenderMaterial getRenderMaterial(boolean ao) {
            return ao ? this.matWithAo : this.matWithoutAo;
        }

        @Override
        @NotNull
        public class_1058 getSprite(class_2350 dir) {
            return this.sprites[dir.ordinal()];
        }

        @Override
        public int getBakeFlags(class_2350 dir) {
            return this.bakeFlags[dir.ordinal()];
        }

        @Override
        public boolean hasColor(class_2350 dir) {
            return (this.hasColorMask & 1 << dir.ordinal()) != 0;
        }

        public String toString() {
            return "ComputedApperance{sprites=%s, bakeFlags=%s, hasColorMask=%s, matWithoutAo=%s, matWithAo=%s}".formatted(Arrays.toString(this.sprites), Arrays.toString(this.bakeFlags), this.hasColorMask, this.matWithoutAo, this.matWithAo);
        }
    }
}

