/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.templates.model;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_2350;

public class TagPacker {
    private static final class_2350[] DIRECTIONS = class_2350.values();
    private static final class_2350[] TAGS = new class_2350[8];

    public static TriState ao(int tag) {
        if (tag <= 7) {
            return TriState.DEFAULT;
        }
        if (tag <= 15) {
            return TriState.FALSE;
        }
        return TriState.TRUE;
    }

    @Nullable
    public static class_2350 dir(int tag) {
        return TAGS[tag & 7];
    }

    public static int withAo(int tag, TriState tri) {
        int dirPart = tag & 7;
        return switch (tri) {
            default -> throw new MatchException(null, null);
            case TriState.DEFAULT -> dirPart;
            case TriState.FALSE -> dirPart + 8;
            case TriState.TRUE -> dirPart + 16;
        };
    }

    public static int withDir(int tag, @Nullable class_2350 dir) {
        int aoPart = tag & 0xFFFFFFF8;
        return aoPart + (dir == null ? 0 : dir.ordinal() + 1);
    }

    public static Builder builder() {
        return TagPacker.builder(0);
    }

    public static Builder builder(int oldTag) {
        return new Builder(oldTag);
    }

    static {
        System.arraycopy(DIRECTIONS, 0, TAGS, 1, DIRECTIONS.length);
        for (class_2350 d : TAGS) {
            for (TriState a : TriState.values()) {
                int tag = TagPacker.builder().withDir(d).withAo(a).build();
                Preconditions.checkArgument((TagPacker.dir(tag) == d ? 1 : 0) != 0, (Object)("dir " + String.valueOf(d) + " dirTag " + String.valueOf(TagPacker.dir(tag))));
                Preconditions.checkArgument((TagPacker.ao(tag) == a ? 1 : 0) != 0, (Object)("ao " + String.valueOf(a) + " aoTag " + String.valueOf(TagPacker.ao(tag))));
                Preconditions.checkArgument((TagPacker.withDir(tag, d) == tag ? 1 : 0) != 0, (Object)("dir " + String.valueOf(d) + " tag " + tag + " withDir " + TagPacker.withDir(tag, d)));
                Preconditions.checkArgument((TagPacker.withAo(tag, a) == tag ? 1 : 0) != 0, (Object)("ao " + String.valueOf(a) + " tag " + tag + " withAo " + TagPacker.withAo(tag, a)));
            }
        }
    }

    public static class Builder {
        int tag;

        public Builder(int tag) {
            this.tag = tag;
        }

        public TriState ao() {
            return TagPacker.ao(this.tag);
        }

        @Nullable
        public class_2350 dir() {
            return TagPacker.dir(this.tag);
        }

        public Builder withAo(TriState tri) {
            this.tag = TagPacker.withAo(this.tag, tri);
            return this;
        }

        public Builder withDir(class_2350 dir) {
            this.tag = TagPacker.withDir(this.tag, dir);
            return this;
        }

        public int build() {
            return this.tag;
        }
    }
}

