/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.templates.model;

import io.github.cottonmc.templates.api.TemplateAppearance;
import io.github.cottonmc.templates.block.TemplateEntity;
import io.github.cottonmc.templates.mixin.MinecraftAccessor;
import io.github.cottonmc.templates.model.MeshTransformUtil;
import io.github.cottonmc.templates.model.TagPacker;
import io.github.cottonmc.templates.model.TemplateAppearanceManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class RetexturingBakedModel
extends ForwardingBakedModel {
    protected final TemplateAppearanceManager tam;
    protected final Mesh baseMesh;
    protected final boolean uvlock;
    protected final boolean ao;
    protected final ConcurrentMap<TemplateAppearance, Mesh> retexturedMeshes = new ConcurrentHashMap<TemplateAppearance, Mesh>();
    protected static final class_2350[] DIRECTIONS = class_2350.values();
    protected static final class_2350[] DIRECTIONS_AND_NULL = new class_2350[DIRECTIONS.length + 1];

    public RetexturingBakedModel(class_1087 baseModel, Mesh baseMesh, TemplateAppearanceManager tam, class_3665 settings, boolean ao) {
        this.wrapped = baseModel;
        this.baseMesh = baseMesh;
        this.tam = tam;
        this.uvlock = settings.method_3512();
        this.ao = ao;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public class_1058 method_4711() {
        return this.tam.getDefaultAppearance().getSprite(class_2350.field_11036);
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2680 s;
        class_2680 theme;
        Object object = blockView.getBlockEntityRenderData(pos);
        class_2680 class_26802 = theme = object instanceof class_2680 ? (s = (class_2680)object) : null;
        if (theme == null || theme.method_26215()) {
            this.getUntintedRetexturedMesh(this.tam.getDefaultAppearance()).outputTo(context.getEmitter());
            return;
        }
        if (theme.method_26204() == class_2246.field_10499) {
            return;
        }
        theme = theme.getAppearance(blockView, pos, class_2350.field_11033, theme, pos);
        TemplateAppearance ta = this.tam.getAppearance(theme);
        Mesh untintedMesh = this.getUntintedRetexturedMesh(ta);
        int tint = 0xFF000000 | class_310.method_1551().method_1505().method_1697(theme, blockView, pos, 0);
        if (tint == -1) {
            untintedMesh.outputTo(context.getEmitter());
        } else {
            context.pushTransform((RenderContext.QuadTransform)new TintingTransformer(ta, tint));
            untintedMesh.outputTo(context.getEmitter());
            context.popTransform();
        }
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        int tint;
        TemplateAppearance nbtAppearance;
        class_2680 theme = TemplateEntity.readStateFromItem(stack);
        if (!theme.method_26215()) {
            nbtAppearance = this.tam.getAppearance(theme);
            tint = 0xFF000000 | ((MinecraftAccessor)class_310.method_1551()).templates$getItemColors().method_1704(new class_1799((class_1935)theme.method_26204()), 0);
        } else {
            nbtAppearance = this.tam.getDefaultAppearance();
            tint = -1;
        }
        Mesh untintedMesh = this.getUntintedRetexturedMesh(nbtAppearance);
        if (tint == -1) {
            untintedMesh.outputTo(context.getEmitter());
        } else {
            context.pushTransform((RenderContext.QuadTransform)new TintingTransformer(nbtAppearance, tint));
            untintedMesh.outputTo(context.getEmitter());
            context.popTransform();
        }
    }

    protected Mesh getUntintedRetexturedMesh(TemplateAppearance ta) {
        return this.retexturedMeshes.computeIfAbsent(ta, this::createUntintedRetexturedMesh);
    }

    protected Mesh createUntintedRetexturedMesh(TemplateAppearance ta) {
        return MeshTransformUtil.pretransformMesh(this.baseMesh, new RetexturingTransformer(ta));
    }

    static {
        System.arraycopy(DIRECTIONS, 0, DIRECTIONS_AND_NULL, 0, DIRECTIONS.length);
    }

    protected static class TintingTransformer
    implements RenderContext.QuadTransform {
        protected final TemplateAppearance ta;
        protected final int tint;

        protected TintingTransformer(TemplateAppearance ta, int tint) {
            this.ta = ta;
            this.tint = tint;
        }

        public boolean transform(MutableQuadView quad) {
            int tag = quad.tag();
            @Nullable class_2350 dir = TagPacker.dir(tag);
            if (dir != null && this.ta.hasColor(dir)) {
                quad.color(this.tint, this.tint, this.tint, this.tint);
            }
            return true;
        }
    }

    protected class RetexturingTransformer
    implements RenderContext.QuadTransform {
        protected final TemplateAppearance ta;

        protected RetexturingTransformer(TemplateAppearance ta) {
            this.ta = ta;
        }

        public boolean transform(MutableQuadView quad) {
            int tag = quad.tag();
            boolean useAo = switch (TagPacker.ao(tag)) {
                default -> throw new MatchException(null, null);
                case TriState.TRUE -> true;
                case TriState.FALSE -> false;
                case TriState.DEFAULT -> RetexturingBakedModel.this.ao;
            };
            quad.material(this.ta.getRenderMaterial(useAo));
            @Nullable class_2350 dir = TagPacker.dir(tag);
            if (dir == null) {
                return true;
            }
            quad.spriteBake(this.ta.getSprite(dir), 0x20 | this.ta.getBakeFlags(dir) | (RetexturingBakedModel.this.uvlock ? 4 : 0));
            return true;
        }
    }
}

