/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.templates.gensupport;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Collection;

public interface Ser<E extends JsonElement> {
    public E ser();

    default public JsonArray serList(Collection<?> list) {
        return Ser.list(list);
    }

    public static JsonArray list(Collection<?> list) {
        JsonArray arr = new JsonArray();
        for (Object item : list) {
            if (item instanceof Ser) {
                Ser s = (Ser)item;
                arr.add(s.ser());
                continue;
            }
            if (item instanceof JsonElement) {
                JsonElement j = (JsonElement)item;
                arr.add(j);
                continue;
            }
            if (item instanceof String) {
                String s = (String)item;
                arr.add(s);
                continue;
            }
            if (item instanceof Number) {
                Number n = (Number)item;
                arr.add(n);
                continue;
            }
            if (item instanceof Boolean) {
                Boolean b = (Boolean)item;
                arr.add(b);
                continue;
            }
            if (item instanceof Character) {
                Character c = (Character)item;
                arr.add(c);
                continue;
            }
            throw new IllegalArgumentException(item.getClass().getName());
        }
        return arr;
    }
}

