/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.templates;

import io.github.cottonmc.templates.Templates;
import io.github.cottonmc.templates.api.TemplatesClientApi;
import io.github.cottonmc.templates.gensupport.ItemOverrideMapping;
import io.github.cottonmc.templates.gensupport.MagicPaths;
import io.github.cottonmc.templates.gensupport.TemplateModelMapping;
import io.github.cottonmc.templates.model.TemplateAppearanceManager;
import io.github.cottonmc.templates.model.TemplateUnbakedModel;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.minecraft.class_1058;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4730;
import net.minecraft.class_7923;

public class TemplatesModelProvider
implements PreparableModelLoadingPlugin<DataModels>,
PreparableModelLoadingPlugin.DataLoader<DataModels> {
    private final Map<class_2960, class_1100> permanentModels = new HashMap<class_2960, class_1100>();
    private final Map<class_1091, class_2960> permanentItemAssignments = new HashMap<class_1091, class_2960>();

    public CompletableFuture<DataModels> load(class_3300 res, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            BufferedReader reader;
            DataModels dms = new DataModels();
            dms.models.putAll(this.permanentModels);
            dms.itemAssignments.putAll(this.permanentItemAssignments);
            TemplatesClientApi api = TemplatesClientApi.getInstance();
            for (class_3298 modelMappingRes : res.method_14489(class_2960.method_60655((String)"templates", (String)"template_model_mappings.json"))) {
                try {
                    reader = modelMappingRes.method_43039();
                    try {
                        List<TemplateModelMapping> modelMappings = MagicPaths.parseJsonArray(reader, TemplateModelMapping.class, TemplateModelMapping::de).toList();
                        Templates.LOG.info("Found {} model mappings from pack '{}'", (Object)modelMappings.size(), (Object)modelMappingRes.method_14480());
                        modelMappings.forEach(modelMapping -> {
                            Map<class_2960, class_1100> map = dms.models;
                            class_2960 class_29602 = modelMapping.id.toMinecraft();
                            map.put(class_29602, switch (modelMapping.kind) {
                                default -> throw new MatchException(null, null);
                                case TemplateModelMapping.Kind.AUTO -> api.auto(modelMapping.base.toMinecraft());
                                case TemplateModelMapping.Kind.JSON -> api.json(modelMapping.base.toMinecraft());
                            });
                        });
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    Templates.LOG.error("Failed to load model mappings from pack '{}'", (Object)modelMappingRes.method_14480(), (Object)e);
                }
            }
            for (class_3298 itemOverrideRes : res.method_14489(class_2960.method_60655((String)"templates", (String)"template_item_overrides.json"))) {
                try {
                    reader = itemOverrideRes.method_43039();
                    try {
                        List<ItemOverrideMapping> itemOverrideMappings = MagicPaths.parseJsonArray(reader, ItemOverrideMapping.class, ItemOverrideMapping::de).toList();
                        Templates.LOG.info("Found {} item model overrides from pack '{}'.", (Object)itemOverrideMappings.size(), (Object)itemOverrideRes.method_14480());
                        itemOverrideMappings.forEach(iom -> dms.itemAssignments.put(new class_1091(iom.itemId.toMinecraft(), "inventory"), iom.modelId.toMinecraft()));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    Templates.LOG.error("Failed to load item overrides from pack '{}'", (Object)itemOverrideRes.method_14480(), (Object)e);
                }
            }
            return dms;
        }, executor);
    }

    public void onInitializeModelLoader(DataModels data, ModelLoadingPlugin.Context ctx) {
        final TemplateAppearanceManager tam = new TemplateAppearanceManager();
        TemplateUnbakedModel.ReinitContext reinitContext = new TemplateUnbakedModel.ReinitContext(){

            @Override
            public TemplateAppearanceManager getTAM(Function<class_4730, class_1058> spriteLookup) {
                tam.ready(spriteLookup);
                return tam;
            }
        };
        for (class_1100 ub : data.models.values()) {
            if (!(ub instanceof TemplateUnbakedModel)) continue;
            TemplateUnbakedModel reinitable = (TemplateUnbakedModel)ub;
            reinitable.reinit(reinitContext);
        }
        ctx.addModels(data.models.keySet());
        ctx.resolveModel().register(rCtx -> data.models.get(rCtx.id()));
        ctx.modifyModelBeforeBake().register(ModelModifier.OVERRIDE_PHASE, (model, context) -> {
            class_2960 modelId = data.itemAssignments.get(context.topLevelId());
            if (modelId == null) {
                return model;
            }
            class_1100 base = data.models.get(modelId);
            if (base == null) {
                return model;
            }
            return base;
        });
    }

    public void addTemplateModel(class_2960 id, class_1100 unbaked) {
        this.permanentModels.put(id, unbaked);
    }

    public void assignItemModel(class_2960 templateModelId, class_1091 ... modelIds) {
        for (class_1091 modelId : modelIds) {
            this.permanentItemAssignments.put(modelId, templateModelId);
        }
    }

    public void assignItemModel(class_2960 templateModelId, class_2960 ... itemIds) {
        for (class_2960 itemId : itemIds) {
            this.permanentItemAssignments.put(new class_1091(itemId, "inventory"), templateModelId);
        }
    }

    public void assignItemModel(class_2960 templateModelId, class_1935 ... itemConvs) {
        for (class_1935 itemConv : itemConvs) {
            this.assignItemModel(templateModelId, class_7923.field_41178.method_10221((Object)itemConv.method_8389()));
        }
    }

    public static class DataModels {
        public final Map<class_2960, class_1100> models = new HashMap<class_2960, class_1100>();
        public final Map<class_1091, class_2960> itemAssignments = new HashMap<class_1091, class_2960>();
    }
}

