/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.templates;

import io.github.cottonmc.templates.TemplatesModelProvider;
import io.github.cottonmc.templates.api.TemplatesClientApi;
import io.github.cottonmc.templates.model.UnbakedAutoRetexturedModel;
import io.github.cottonmc.templates.model.UnbakedJsonRetexturedModel;
import io.github.cottonmc.templates.model.UnbakedMeshRetexturedModel;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import org.jetbrains.annotations.NotNull;

public class TemplatesClientApiImpl
implements TemplatesClientApi {
    private final TemplatesModelProvider prov;

    public TemplatesClientApiImpl(TemplatesModelProvider prov) {
        this.prov = prov;
    }

    @Override
    public TemplatesClientApi.TweakableUnbakedModel auto(class_2960 parent) {
        return new UnbakedAutoRetexturedModel(parent);
    }

    @Override
    public TemplatesClientApi.TweakableUnbakedModel json(class_2960 parent) {
        return new UnbakedJsonRetexturedModel(parent);
    }

    @Override
    public TemplatesClientApi.TweakableUnbakedModel mesh(class_2960 parent, Function<Function<class_4730, class_1058>, Mesh> baseMeshFactory) {
        return new UnbakedMeshRetexturedModel(parent, baseMeshFactory);
    }

    @Override
    public void addTemplateModel(class_2960 id, class_1100 unbaked) {
        this.prov.addTemplateModel(id, unbaked);
    }

    @Override
    public void assignItemModel(class_2960 templateModelId, class_1091 ... modelIds) {
        this.prov.assignItemModel(templateModelId, modelIds);
    }

    @Override
    public void assignItemModel(class_2960 templateModelId, class_2960 ... itemIds) {
        this.prov.assignItemModel(templateModelId, itemIds);
    }

    @Override
    public void assignItemModel(class_2960 templateModelId, class_1935 ... itemConvs) {
        this.prov.assignItemModel(templateModelId, itemConvs);
    }

    @Override
    @NotNull
    public Renderer getFabricRenderer() {
        Renderer obj = RendererAccess.INSTANCE.getRenderer();
        if (obj != null) {
            return obj;
        }
        Object msg = "A Fabric Rendering API implementation is required to use Templates 2!";
        if (!FabricLoader.getInstance().isModLoaded("fabric-renderer-indigo")) {
            msg = (String)msg + "\nI noticed you don't have Indigo installed, which is a part of the complete Fabric API package.";
        }
        if (FabricLoader.getInstance().isModLoaded("sodium")) {
            msg = (String)msg + "\nI noticed you have Sodium installed - consider also installing Indium to provide a compatible renderer implementation.";
        }
        throw new NullPointerException((String)msg);
    }
}

