/*
 * Decompiled with CFR 0.152.
 */
package com.bigenergy.ftbqopt.mixin;

import com.bigenergy.ftbqopt.config.FTBQuestsOptimizerConfig;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.FTBQuestsInventoryListener;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={FTBQuestsInventoryListener.class}, remap=false)
public class FTBQuestsInventoryListenerMixin {
    @Shadow
    public final class_3222 player;
    @Unique
    private static int fTBQuestsOptimizer$ticksSkipped = 0;
    @Unique
    private static final int fTBQuestsOptimizer$skipTicksAmount = (Integer)FTBQuestsOptimizerConfig.SKIP_TICKS_AMOUNT.get();

    public FTBQuestsInventoryListenerMixin(class_3222 player) {
        this.player = player;
    }

    @Unique
    private static boolean fTBQuestsOptimizer$tryTick() {
        if (++fTBQuestsOptimizer$ticksSkipped > fTBQuestsOptimizer$skipTicksAmount) {
            fTBQuestsOptimizer$ticksSkipped = 0;
            return true;
        }
        return false;
    }

    @Overwrite
    public static void detect(class_3222 player, class_1799 craftedItem, long sourceTask) {
        if (!FTBQuestsInventoryListenerMixin.fTBQuestsOptimizer$tryTick()) {
            return;
        }
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file == null || PlayerHooks.isFake((class_1657)player)) {
            return;
        }
        if (((Boolean)FTBQuestsOptimizerConfig.DETECT_OPTIMIZATION.get()).booleanValue()) {
            TeamData data;
            FTBTeamsAPI.API api;
            Team team2;
            List submitTasks = file.getSubmitTasks();
            List craftingTasks = file.getCraftingTasks();
            if (!(submitTasks.isEmpty() && craftingTasks.isEmpty() || (team2 = (Team)(api = FTBTeamsAPI.api()).getManager().getTeamForPlayer(player).orElse(null)) == null || (data = file.getNullableTeamData(team2.getId())) == null || data.isLocked())) {
                file.withPlayerContext(player, () -> {
                    List tasksToCheck = craftedItem.method_7960() ? submitTasks : craftingTasks;
                    for (Task task : tasksToCheck) {
                        if (task.id == sourceTask || !data.canStartTasks(task.getQuest())) continue;
                        task.submitTask(data, player, craftedItem);
                    }
                });
            }
        } else {
            List tasksToCheck;
            List list = tasksToCheck = craftedItem.method_7960() ? file.getSubmitTasks() : file.getCraftingTasks();
            if (!tasksToCheck.isEmpty()) {
                FTBTeamsAPI.api().getManager().getTeamForPlayer(player).ifPresent(team -> {
                    TeamData data = file.getNullableTeamData(team.getId());
                    if (data != null && !data.isLocked()) {
                        file.withPlayerContext(player, () -> {
                            for (Task task : tasksToCheck) {
                                if (task.id == sourceTask || !data.canStartTasks(task.getQuest())) continue;
                                task.submitTask(data, player, craftedItem);
                            }
                        });
                    }
                });
            }
        }
    }
}

