/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.system;

import cn.leolezury.eternalstarlight.common.data.ESBiomeData;
import cn.leolezury.eternalstarlight.common.data.ESDataTransformers;
import cn.leolezury.eternalstarlight.common.world.gen.system.BiomeData;
import cn.leolezury.eternalstarlight.common.world.gen.system.WorldGenProvider;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.DataTransformer;
import net.minecraft.class_2378;

public class WorldArea {
    public final WorldGenProvider provider;
    public final long seed;
    public final int areaX;
    public final int areaZ;
    private int[][] biomes;
    private int[] finalBiomes;
    private int[][] heights;
    private int[] finalHeights;
    public int size;

    public WorldArea(WorldGenProvider provider, int areaX, int areaZ, int size, long seed) {
        this.provider = provider;
        this.areaX = areaX;
        this.areaZ = areaZ;
        this.size = size;
        this.seed = seed;
    }

    public void initBiomes() {
        this.biomes = new int[this.size][this.size];
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                this.biomes[x][z] = this.provider.getBiomeDataId((BiomeData)this.provider.biomeDataRegistry.method_29107(ESBiomeData.STARLIGHT_FOREST));
            }
        }
    }

    public void transformBiomes(DataTransformer transformer, long seedAddition) {
        this.biomes = transformer.transform(this.biomes, this.biomes, this.provider, this.areaX, this.areaZ, this.size, this.seed, seedAddition);
        this.size = this.biomes.length;
    }

    public void initHeights() {
        this.heights = new int[this.size][this.size];
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                this.heights[x][z] = this.provider.getBiomeDataById(this.biomes[x][z]).height();
            }
        }
    }

    public void transformHeights(DataTransformer transformer, long seedAddition) {
        this.heights = transformer.transform(this.heights, this.biomes, this.provider, this.areaX, this.areaZ, this.size, this.seed, seedAddition);
    }

    public void finalizeAll(class_2378<DataTransformer> registry) {
        int i;
        int tempSize = this.size;
        this.transformBiomes((DataTransformer)registry.method_31140(ESDataTransformers.FINALIZE_BIOMES), 0L);
        int finalSize = this.size;
        this.size = tempSize;
        this.transformHeights((DataTransformer)registry.method_31140(ESDataTransformers.FINALIZE_HEIGHTS), 0L);
        this.size = finalSize;
        this.finalBiomes = new int[this.size * this.size];
        for (i = 0; i < this.size; ++i) {
            System.arraycopy(this.biomes[i], 0, this.finalBiomes, i * this.size, this.size);
        }
        this.finalHeights = new int[this.size * this.size];
        for (i = 0; i < this.size; ++i) {
            System.arraycopy(this.heights[i], 0, this.finalHeights, i * this.size, this.size);
        }
    }

    public BiomeData getBiomeData(int x, int z) {
        return this.provider.getBiomeDataById(this.getBiome(x, z));
    }

    public int getBiome(int x, int z) {
        int dataX = (this.size == 1024 ? x : (int)Math.floor((double)(x * this.size) / 1024.0)) & this.size - 1;
        int dataZ = (this.size == 1024 ? z : (int)Math.floor((double)(z * this.size) / 1024.0)) & this.size - 1;
        return this.finalBiomes[this.size * dataX + dataZ];
    }

    public int getHeight(int x, int z) {
        int dataX = (this.size == 1024 ? x : (int)Math.floor((double)(x * this.size) / 1024.0)) & this.size - 1;
        int dataZ = (this.size == 1024 ? z : (int)Math.floor((double)(z * this.size) / 1024.0)) & this.size - 1;
        return this.finalHeights[this.size * dataX + dataZ];
    }
}

